/*
 * Copyright (c) 1999-2005 eVelopers Corporation. All rights reserved.
 *
 * This is open source software; you can use, redistribute and/or modify 
 * it under the terms of the Open Software Licence v 2.1 as published by the Open 
 * Source Initiative.
 *
 * You should have received a copy of the Open Software Licence along with this
 * application; if not, contact the Open Source Initiative (http://opensource.org).
 */
package com.evelopers.unimod.analysis.executors;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @uml.dependency   supplier="com.evelopers.unimod.analysis.executors.Position" stereotypes="Basic::Responsibility"
 */
public class Substitution {
    private long substitution = 0;

    private int bits;
    private Map positions;
    private List predicatePositions;
    
    public Substitution(int bits, Map positions, List predicatePositions) {
        this.bits = bits;
        this.positions = positions;
        this.predicatePositions = predicatePositions;
    }

    public boolean getBooleanVarValue(String variableName) {
        Position position = (Position) positions.get(variableName);
        return ((substitution >> position.position) & 1) != 0;
    }

    public boolean getPredicateValue(String variableName, int predicateType, Object value) {
        PredicatePosition position = (PredicatePosition) positions.get(variableName);
        long s = getPredicateSubstitution(position);
        return position.predicateExecutor.execute(predicateType, value, (int) s);
    }
    
    public void reset() {
        substitution = 0;
    }
    
    public long getSubstitution() {
        return substitution;
    } 
    
    public void nextSubstitution() {
        substitution ++;
        for (Iterator i = predicatePositions.iterator(); i.hasNext();) {
            PredicatePosition position = (PredicatePosition) i.next();
            long value = getPredicateSubstitution(position);
            if (value >= position.cardinality) {
                substitution += ((1L << position.bits) - position.cardinality) << position.position;
            }
        }
    }
    
    public boolean hasMoreSubstitutions() {
        return substitution < (1L << bits); 
    }

    int getBits() {
        return bits;
    }
    
    Map getPositions() {
        return positions;
    }
    
    private long getPredicateSubstitution(PredicatePosition position) {
        return (substitution >> position.position) & ((1L << position.bits) - 1);
    }
}
