/*
 * Copyright (c) 1999-2005 eVelopers Corporation. All rights reserved.
 *
 * This is open source software; you can use, redistribute and/or modify 
 * it under the terms of the Open Software Licence v 2.1 as published by the Open 
 * Source Initiative.
 *
 * You should have received a copy of the Open Software Licence along with this
 * application; if not, contact the Open Source Initiative (http://opensource.org).
 */
package com.evelopers.unimod.analysis.executors;

import com.evelopers.unimod.parser.ExprParser;
import com.evelopers.unimod.parser.ExprTokenTypes;


/**
 * @uml.dependency   supplier="com.evelopers.unimod.analysis.executors.Interval"
 */
class RangePredicateExecutor implements PredicateExecutor {
    private Interval[] intervals; 
   
    public RangePredicateExecutor(Interval[] intervals) {
        this.intervals = intervals;
    }

    public boolean execute(int predicateType, Object value, int substitution) {
        Interval interval = intervals[substitution];
        
        int cmpWithMax = interval.getMax().compareTo(value);
        int cmpWithMin = interval.getMin().compareTo(value);
        
        switch (predicateType) {
            case ExprTokenTypes.EQUAL:
                return cmpWithMax == 0 && interval.isRightIncluded();
            case ExprTokenTypes.NEQUAL:
                return cmpWithMax != 0 || !interval.isRightIncluded();
            case ExprTokenTypes.LT:
                return cmpWithMax <  0 || (cmpWithMax == 0 && ! interval.isRightIncluded());
            case ExprTokenTypes.LE:
                return cmpWithMax <= 0;
            case ExprTokenTypes.GT:
                return cmpWithMin >  0 || (cmpWithMin == 0 && ! interval.isLeftIncluded()); 
            case ExprTokenTypes.GE:
                return cmpWithMin >= 0; 
            default:
                throw new IllegalArgumentException("Bad predicate type: " + 
                        ExprParser._tokenNames[predicateType]);
        }
    }

    public int getCardinality() {
        return intervals.length;
    }

    Interval getInterval(int substitution) {
        return intervals[substitution];
    }
}
