/*
 * Copyright (c) 1999-2005 eVelopers Corporation. All rights reserved.
 *
 * This is open source software; you can use, redistribute and/or modify 
 * it under the terms of the Open Software Licence v 2.1 as published by the Open 
 * Source Initiative.
 *
 * You should have received a copy of the Open Software Licence along with this
 * application; if not, contact the Open Source Initiative (http://opensource.org).
 */
package com.evelopers.unimod.analysis.executors;

import java.util.Set;

class FinitSetPredicateExecutorBuilder extends DiscreteSetPredicateExecutorBuilder {
    private Set values;
    
    public FinitSetPredicateExecutorBuilder(Set values) {
        if (values == null) {
            throw new IllegalArgumentException("Values set should not be null");
        }
        this.values = values;
    }
    
    public void addPredicate(int predicateType, Object value) {
        if (! values.contains(value)) {
            throw new IllegalArgumentException("Value [" + value + "] is not from set " + values);
        }
        super.addPredicate(predicateType, value);        
    }
    
    protected boolean isOtherValueUsed() {
        return getUsedValues().size() < values.size();
    }
}
