/*
 * Copyright (c) 1999-2005 eVelopers Corporation. All rights reserved.
 *
 * This is open source software; you can use, redistribute and/or modify 
 * it under the terms of the Open Software Licence v 2.1 as published by the Open 
 * Source Initiative.
 *
 * You should have received a copy of the Open Software Licence along with this
 * application; if not, contact the Open Source Initiative (http://opensource.org).
 */
package com.evelopers.unimod.analysis.executors;

import com.evelopers.unimod.parser.ExprParser;
import com.evelopers.unimod.parser.ExprTokenTypes;

/**
 * Variable of the 
 * 
 * @author mmazin
 */
class DiscreteSetPredicateExecutor implements PredicateExecutor {
    private Object[] values;

    public DiscreteSetPredicateExecutor(Object[] values) {
        this.values = values;
    }
    
    public boolean execute(int predicateType, Object value, int substitution) {
        switch (predicateType) {
            case ExprTokenTypes.EQUAL:
                return values[substitution].equals(value);
            case ExprTokenTypes.NEQUAL:
                return ! values[substitution].equals(value);
            default:
                throw new IllegalArgumentException("Bad predicate type: " + 
                        ExprParser._tokenNames[predicateType]);
        }
    }

    public int getCardinality() {
        return values.length;
    }

    Object getValue(int substitution) {
        return values[substitution];
    }
}
