// $ANTLR : "OldTypeInfoProviderBuilder.g" -> "OldTypeInfoProviderBuilder.java"$

    package com.evelopers.unimod.analysis;

	import java.util.Set;
	import java.util.HashSet;

import antlr.TreeParser;
import antlr.Token;
import antlr.collections.AST;
import antlr.RecognitionException;
import antlr.ANTLRException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.collections.impl.BitSet;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;


/**
 * Gathers predicates and boolean variables. Set objectValues to 
 * constant nodes. Use case:
 * <pre><code>
 *   Gatherer gatherer = new Gatherer(typeInfoProvider);
 *   gatherer.gather(ast);
 *   SubstitutionBuilder builder = gatherer.getBuilder();
 *   Substitution substitution = builder.buildSubstitution();
 * </code></pre>
 * @deprecated
 */
public class OldTypeInfoProviderBuilder extends antlr.TreeParser       implements OldTypeInfoProviderBuilderTokenTypes
 {

	private Set booleanVariables = new HashSet();
	private Set intVariables = new HashSet();
	
	public TypeInfoProvider buildProvider() {
		return new TypeInfoProvider() {
            protected Set getValuesSet(String variableName) {
                return null;
            }
        
            protected Class getValueClass(String variableName) {
                return null;
            }
        
            protected int getType(String variableName) {
                if (booleanVariables.contains(variableName)) {
                    return TypeInfo.BOOLEAN.getType();
                } else if (intVariables.contains(variableName)) {
                    return TypeInfo.INT.getType();
                } else {
                    return -1;
                }
            }        
        };
	}
	
	public static TypeInfoProvider buildProvider(AST formula) throws RecognitionException {
		OldTypeInfoProviderBuilder builder = new OldTypeInfoProviderBuilder();
		builder.gather(formula);
		return builder.buildProvider();
	}
	
	private void addBooleanVariable(String variableName) throws RecognitionException {
		if (intVariables.contains(variableName)) {
		    throw new RecognitionException(variableName + " variable appears both in boolean and integer context");
        }
        booleanVariables.add(variableName);
	}
    
    private void addIntVariable(AST predicate) throws RecognitionException {
        AST op1 = predicate.getFirstChild();
        AST op2 = op1.getNextSibling();        
        String variableName = null;
        if (op1.getType() == IDENT) {
            variableName = op1.getText();
        } else if (op2.getType() == IDENT) {
            variableName = op2.getText();
        }
        if (variableName != null) {
            if (booleanVariables.contains(variableName)) {
                throw new RecognitionException(variableName + " variable appears both in boolean and integer context");
            }
            intVariables.add(variableName);
        }
    }
public OldTypeInfoProviderBuilder() {
	tokenNames = _tokenNames;
}

	public final void gather(AST _t) throws RecognitionException {
		
		AST gather_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST eq = null;
		AST ne = null;
		AST ge = null;
		AST le = null;
		AST gt = null;
		AST lt = null;
		AST id = null;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case OR:
		{
			AST __t239 = _t;
			AST tmp1_AST_in = (AST)_t;
			match(_t,OR);
			_t = _t.getFirstChild();
			{
			int _cnt241=0;
			_loop241:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_0.member(_t.getType()))) {
					gather(_t);
					_t = _retTree;
				}
				else {
					if ( _cnt241>=1 ) { break _loop241; } else {throw new NoViableAltException(_t);}
				}
				
				_cnt241++;
			} while (true);
			}
			_t = __t239;
			_t = _t.getNextSibling();
			break;
		}
		case AND:
		{
			AST __t242 = _t;
			AST tmp2_AST_in = (AST)_t;
			match(_t,AND);
			_t = _t.getFirstChild();
			{
			int _cnt244=0;
			_loop244:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_0.member(_t.getType()))) {
					gather(_t);
					_t = _retTree;
				}
				else {
					if ( _cnt244>=1 ) { break _loop244; } else {throw new NoViableAltException(_t);}
				}
				
				_cnt244++;
			} while (true);
			}
			_t = __t242;
			_t = _t.getNextSibling();
			break;
		}
		case NOT:
		{
			AST __t245 = _t;
			AST tmp3_AST_in = (AST)_t;
			match(_t,NOT);
			_t = _t.getFirstChild();
			{
			gather(_t);
			_t = _retTree;
			}
			_t = __t245;
			_t = _t.getNextSibling();
			break;
		}
		case EQUAL:
		{
			eq = (AST)_t;
			match(_t,EQUAL);
			_t = _t.getNextSibling();
			addIntVariable(eq);
			break;
		}
		case NEQUAL:
		{
			ne = (AST)_t;
			match(_t,NEQUAL);
			_t = _t.getNextSibling();
			addIntVariable(ne);
			break;
		}
		case GE:
		{
			ge = (AST)_t;
			match(_t,GE);
			_t = _t.getNextSibling();
			addIntVariable(ge);
			break;
		}
		case LE:
		{
			le = (AST)_t;
			match(_t,LE);
			_t = _t.getNextSibling();
			addIntVariable(le);
			break;
		}
		case GT:
		{
			gt = (AST)_t;
			match(_t,GT);
			_t = _t.getNextSibling();
			addIntVariable(gt);
			break;
		}
		case LT:
		{
			lt = (AST)_t;
			match(_t,LT);
			_t = _t.getNextSibling();
			addIntVariable(lt);
			break;
		}
		case IDENT:
		{
			id = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			addBooleanVariable(id.getText());
			break;
		}
		case TRUE:
		case FALSE:
		{
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TRUE:
			{
				AST tmp4_AST_in = (AST)_t;
				match(_t,TRUE);
				_t = _t.getNextSibling();
				break;
			}
			case FALSE:
			{
				AST tmp5_AST_in = (AST)_t;
				match(_t,FALSE);
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"TRUE",
		"FALSE",
		"OR",
		"AND",
		"NOT",
		"LPAREN",
		"RPAREN",
		"EQUAL",
		"NEQUAL",
		"GE",
		"GT",
		"LE",
		"LT",
		"IDENT",
		"CONST_BOOL",
		"CONST_NUM",
		"WS",
		"DIGIT",
		"LETTER",
		"NAME",
		"CONST_BOOL_OR_IDENT"
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 260592L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	}
	
