// $ANTLR : "Gatherer.g" -> "Gatherer.java"$

    package com.evelopers.unimod.analysis;

    import com.evelopers.unimod.analysis.executors.SubstitutionBuilder;
	import com.evelopers.unimod.parser.ConstNode;

import antlr.TreeParser;
import antlr.Token;
import antlr.collections.AST;
import antlr.RecognitionException;
import antlr.ANTLRException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.collections.impl.BitSet;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;


/**
 * Gathers predicates and boolean variables. Set objectValues to 
 * constant nodes. Use case:
 * <pre><code>
 *   Gatherer gatherer = new Gatherer(typeInfoProvider);
 *   gatherer.gather(ast);
 *   SubstitutionBuilder builder = gatherer.getBuilder();
 *   Substitution substitution = builder.buildSubstitution();
 * </code></pre>
 */
public class Gatherer extends antlr.TreeParser       implements GathererTokenTypes
 {

	private TypeInfoProvider typeInfoProvider;		
	private SubstitutionBuilder builder;

	public Gatherer(TypeInfoProvider typeInfoProvider) {
		this();
		this.typeInfoProvider = typeInfoProvider;
		this.builder = new SubstitutionBuilder(typeInfoProvider);
	}		
	
	public SubstitutionBuilder getBuilder() {
		return builder;
	}
	
	private void addPredicate(AST predicate) {		
		AST op1 = predicate.getFirstChild();
        AST op2 = op1.getNextSibling();
        String variableName;
        ConstNode constNode;
        if (op1.getType() == IDENT && op2.getType() == CONST_NUM) {
            variableName = op1.getText();
            constNode = (ConstNode) op2;
            builder.addPredicate(predicate.getType(), variableName, constNode.getText());
            constNode.setObjectValue(typeInfoProvider.parseConstant(variableName, constNode.getText()));
        } else if (op2.getType() == IDENT && op1.getType() == CONST_NUM) {
            variableName = op2.getText();
            constNode = (ConstNode) op1;
            builder.addPredicate(getReflected(predicate.getType()), variableName, constNode.getText());
            constNode.setObjectValue(typeInfoProvider.parseConstant(variableName, constNode.getText()));
        } else {
            reportWarning("predicate " + predicate + " skippped");
            variableName = null;
            constNode = null;
        }
	}	
	
	private int getReflected(int type) {
		switch (type) {
			case EQUAL: return EQUAL;
			case NEQUAL: return NEQUAL;
			case GE: return LE;
			case LE: return GE;
			case GT: return LT;
			case LT: return GT;
			default: throw new IllegalArgumentException();
		}
	}
public Gatherer() {
	tokenNames = _tokenNames;
}

	public final void gather(AST _t) throws RecognitionException {
		
		AST gather_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST eq = null;
		AST ne = null;
		AST ge = null;
		AST le = null;
		AST gt = null;
		AST lt = null;
		AST id = null;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case OR:
		{
			AST __t249 = _t;
			AST tmp1_AST_in = (AST)_t;
			match(_t,OR);
			_t = _t.getFirstChild();
			{
			int _cnt251=0;
			_loop251:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_0.member(_t.getType()))) {
					gather(_t);
					_t = _retTree;
				}
				else {
					if ( _cnt251>=1 ) { break _loop251; } else {throw new NoViableAltException(_t);}
				}
				
				_cnt251++;
			} while (true);
			}
			_t = __t249;
			_t = _t.getNextSibling();
			break;
		}
		case AND:
		{
			AST __t252 = _t;
			AST tmp2_AST_in = (AST)_t;
			match(_t,AND);
			_t = _t.getFirstChild();
			{
			int _cnt254=0;
			_loop254:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_0.member(_t.getType()))) {
					gather(_t);
					_t = _retTree;
				}
				else {
					if ( _cnt254>=1 ) { break _loop254; } else {throw new NoViableAltException(_t);}
				}
				
				_cnt254++;
			} while (true);
			}
			_t = __t252;
			_t = _t.getNextSibling();
			break;
		}
		case NOT:
		{
			AST __t255 = _t;
			AST tmp3_AST_in = (AST)_t;
			match(_t,NOT);
			_t = _t.getFirstChild();
			{
			gather(_t);
			_t = _retTree;
			}
			_t = __t255;
			_t = _t.getNextSibling();
			break;
		}
		case EQUAL:
		{
			eq = (AST)_t;
			match(_t,EQUAL);
			_t = _t.getNextSibling();
			addPredicate(eq);
			break;
		}
		case NEQUAL:
		{
			ne = (AST)_t;
			match(_t,NEQUAL);
			_t = _t.getNextSibling();
			addPredicate(ne);
			break;
		}
		case GE:
		{
			ge = (AST)_t;
			match(_t,GE);
			_t = _t.getNextSibling();
			addPredicate(ge);
			break;
		}
		case LE:
		{
			le = (AST)_t;
			match(_t,LE);
			_t = _t.getNextSibling();
			addPredicate(le);
			break;
		}
		case GT:
		{
			gt = (AST)_t;
			match(_t,GT);
			_t = _t.getNextSibling();
			addPredicate(gt);
			break;
		}
		case LT:
		{
			lt = (AST)_t;
			match(_t,LT);
			_t = _t.getNextSibling();
			addPredicate(lt);
			break;
		}
		case IDENT:
		{
			id = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			builder.addBooleanVar(id.getText());
			break;
		}
		case TRUE:
		case FALSE:
		{
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TRUE:
			{
				AST tmp4_AST_in = (AST)_t;
				match(_t,TRUE);
				_t = _t.getNextSibling();
				break;
			}
			case FALSE:
			{
				AST tmp5_AST_in = (AST)_t;
				match(_t,FALSE);
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"TRUE",
		"FALSE",
		"OR",
		"AND",
		"NOT",
		"LPAREN",
		"RPAREN",
		"EQUAL",
		"NEQUAL",
		"GE",
		"GT",
		"LE",
		"LT",
		"IDENT",
		"CONST_BOOL",
		"CONST_NUM",
		"WS",
		"DIGIT",
		"LETTER",
		"NAME",
		"CONST_BOOL_OR_IDENT"
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 260592L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	}
	
