/*
 * Developed by eVelopers Corporation
 *
 * Copyright (c) 1999-2003 eVelopers Corporation. All rights reserved.
 * This software is the confidential and proprietary information of
 * eVelopers Corporation. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of
 * the license agreement you entered into with eVelopers.
 *
 * $Date: 04-Mar-04 19:39:12$
 *
 */
package com.evelopers.common.util.helper;

import java.io.*;
import java.util.*;

/**
 * Implements some useful utility methods for working with strings.
 *
 * @author kex
 * @version $Revision: 3$
 */
public class StringHelper {

  /**
   * Private constructor deny to create instances of this class.
   */
  private StringHelper() {
  }

  public static boolean isEmpty(String str) {
    return str == null || "".equals(str);
  }

  /**
   * Replaces source string with replace string if source string equals to null
   *
   * @param sourceStr string to replace
   * @param replaceStr replacement
   * @return resulting string
   */
  public static String nvl(String sourceStr, String replaceStr) {
    return (sourceStr != null) ? sourceStr : replaceStr;
  }

  /**
   * Replaces source string with "" if source string equals to null
   *
   * @param sourceStr string to replace
   * @return resulting string
   */
  public static String nvl(String sourceStr) {
    return nvl(sourceStr, "");
  }

  /**
   * Replaces <code>replacedString</code> with <code>newString</code> in <code>text</code>.
   * <b>Do not use this method under JDK 1.4, instead of
   * it use {@link java.lang.String#replaceAll(String, String)}.</b>
   *
   * @param text text where to replace
   * @param replacedString string to replace
   * @param newString new string
   * @return new text
   */
  public static String replaceAll(String text, String replacedString,
				  String newString) {
    int lastIndex = -newString.length();
    int replacedStringLength = replacedString.length();
    int newStringLength = newString.length();
    while ((lastIndex = text.indexOf(replacedString,
				     lastIndex + newStringLength)) != -1) {
      text = text.substring(0, lastIndex) + newString +
	  text.substring(lastIndex + replacedStringLength);
    }
    return text;
  }

  /**
   * Converts trace of given exception to string representaion.
   * @param e exception which trace to convert to string
   * @return trace string
   * @see com.evelopers.common.exception.CommonException#getTrace
   * @see com.evelopers.common.exception.CommonException#getParentTrace
   * @see com.evelopers.common.exception.CommonException#getRootTrace
   */
  public static String stackTraceToString(Throwable e) {
    StringWriter strwrt = new StringWriter();
    e.printStackTrace(new PrintWriter(strwrt));

    return strwrt.toString();
  }

  /**
    * Create an array of strings from given string splitted by given delimeters.
    * @param str original string
    * @param delim delimeters
    * @return an array of strings. Every string is trimmed.
    **/
   public static String[] splitString(String str, String delim) {
     if (str == null) {
       return null;
     }

     StringTokenizer st = new StringTokenizer(str, delim);
     String[] strArray = new String[st.countTokens()];
     for (int i = 0; st.hasMoreTokens(); i++) {
      strArray[i] = st.nextToken().trim();
     }

     return strArray;
   }

    /**
     * Splits string by not-escaped delimeter char, all escaped
     * delimeters are tranlated to not-escaped symbols
     * @param text string to be splitted
     * @param delimeter delimenter character
     * @return array of tokens
     */
    public static String[] splitEscaped(String text , char delimeter) {

        if ( (text == null) || (text.length() == 0) ) {
            return null;
        }

        String strDelimeter = new String(new char[] {delimeter} );
        String strEscDelimeter  = "\\" + delimeter;
        char[] cText = text.toCharArray();
        int start = 0;
        int i = 1;

        List tokens = new ArrayList();
        String token;
        if ( cText[0] == delimeter ) {
            tokens.add( "" );
            i = 1;
            start = 1;
        }

        if ( cText.length == 1 ) {
            // do nothing
        } else {
            while ( true ) {
                if ( (cText[i] == delimeter) && (cText[i-1] != '\\') ) {
                    token = new String(cText , start , i-start);
                    token = replaceAll(token , strEscDelimeter , strDelimeter);
                    tokens.add( token );
                    start = i+1;
                }
                i++;
                if ( i == cText.length ) {
                    break;
                }
            }
        }


        token = new String(cText , start , cText.length - start);
        token = replaceAll(token , strEscDelimeter , strDelimeter);
        tokens.add(token);

        return (String[]) tokens.toArray(new String[tokens.size()]);
    }

}
