/*
 * Developed by eVelopers Corporation
 *
 * Copyright (c) 1999-2003 eVelopers Corporation. All rights reserved.
 * This software is the confidential and proprietary information of
 * eVelopers Corporation. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of
 * the license agreement you entered into with eVelopers.
 *
 * $Date: 13-Nov-03 12:19:38$
 *
 */
package com.evelopers.common.util.helper;

import java.util.*;

/**
 * Implements some useful utility methods for working with booleans.
 *
 * @author freeman
 * @version $Revision: 1$
 */
public class BooleanHelper
{
    /**
     * Default mapping of string values to boolean ones
     */
	private static HashMap booleanValues = null;

	static 
	{
		booleanValues = new HashMap();
        
		booleanValues.put("false", Boolean.FALSE);
		booleanValues.put("no", Boolean.FALSE);
		booleanValues.put("n", Boolean.FALSE);
		booleanValues.put(null, Boolean.FALSE);
		booleanValues.put("null", Boolean.FALSE);
		booleanValues.put("0", Boolean.FALSE);

		booleanValues.put("true", Boolean.TRUE);
		booleanValues.put("yes", Boolean.TRUE);
		booleanValues.put("y", Boolean.TRUE);
		booleanValues.put("1", Boolean.TRUE);
	}
	
	/**
	 * Private constructor deny to create instances of this class.
	 */
	private BooleanHelper() 
	{
	}

	/**
	 * Wrapper method. Uses default array to search for TRUE values.
	 *
	 * @param value String key for search  
	 * @return Returning boolean value of searched key 
	 */
	public static boolean getBoolean(String value) 
	{
		Boolean b = (Boolean) booleanValues.get(value);
		return (b == null) ? false : b.booleanValue();
	}

	/**
	 * It is the main method to check if the property has some of TRUE values.
	 * Checks if recieved value is in boolTrueValues array and
	 * return TRUE if found, and FALSE otherwise.
	 * @param value String value for search
	 * @param boolTrueValues Array to be search for TRUE variants
	 * @return true or false (see method's description)
	 */
	public static boolean getBoolean(String value, String[] boolTrueValues) 
	{
        if (boolTrueValues == null) {
            return false;
        }
		for(int i = 0; i < boolTrueValues.length; i++)
		{
			if(value.equals(boolTrueValues[i])) return true;
		}

        return false;
	}
}
