/*
 * Developed by eVelopers Corporation
 *
 * Copyright (c) 1999-2003 eVelopers Corporation. All rights reserved.
 * This software is the confidential and proprietary information of
 * eVelopers Corporation. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of
 * the license agreement you entered into with eVelopers.
 *
 * $Date: 01-Oct-04 14:51:33$
 *
 */
package com.evelopers.common.util.helper;

/**
 * Implements some useful utility methods for working with arrays.
 *
 * @author kex
 * @version $Revision: 3$
 */
public class ArrayHelper {

  /**
   * Private constructor deny to create instcance of this class.
   */
  private ArrayHelper() {
  }

  /**
   * Checks if an array has only null references. Also returns true if given array
   * equals to null.
   *
   * @param objects an array of objects to ckeck
   * @return true if array is empty, false otherwise
   **/
  public static boolean isEmpty(Object objects[]) {
    if (objects == null) {
      return true;
    }
    for (int i = 0; i < objects.length; i++) {
      if (objects[i] != null) {
	return false;
      }
    }
    return true;
  }

  /**
   * This method checks if an array of strings is empty or not. Empty means
   * that string reference is null or string length equals to 0. Also returns
   * true if given array equals to null.
   *
   * @param strings an array of strings to ckeck
   * @return true if array is empty, false otherwise
   **/
  public static boolean isEmpty(String strings[]) {
    if (strings == null) {
      return true;
    }
    for (int i = 0; i < strings.length; i++) {
      if (!StringHelper.isEmpty(strings[i])) {
	return false;
      }
    }
    return true;
  }

}
