/*
 * Developed by eVelopers Corporation - Mar 2, 2004
 *
 * Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 * This software is the confidential and proprietary information of
 * eVelopers Corporation. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of
 * the license agreement you entered into with eVelopers.
 *
 * $$Date: 21-Jul-05 17:07:09$
 *
 */

package com.evelopers.common.util.db;

import java.sql.*;

/**
 * @author magus
 * @version $Revision: 3$
 */
public class SQLUtil {

    public static void closeConnection(ResultSet rs) throws SQLException {
        Statement st = rs.getStatement();
        closeConnection(st.getConnection(), st, rs);
    }
    /**
     * Closes all given "objects"
     * @param con Connection to be closed
     * @param stmt Statement to be closed
     * @param rs ResultSet to be closed
     */
    public static void closeConnection(Connection con , Statement stmt , ResultSet rs) throws SQLException {
        // Close result set
        if ( rs != null ) {
            rs.close();
        }
        // Close statement
        if ( stmt != null ) {
            stmt.close();
        }
        // Close Connection
        if ( (con != null) && (con.isClosed() == false) ) {
            con.close();
        }
    }


    /**
     * Closess Connection without exception throwing
     * @param con
     */
    public static void forceCloseConnection(Connection con) {
        try {
            if ( (con != null) && (con.isClosed() == false) ) {
                con.close();
            }
        } catch (SQLException ex) {
        }
    }

    /**
     * Closes all given "objects" without exception throwing.
     * @param con Connection to be closed
     * @param stmt Statement to be closed
     * @param rs ResultSet to be closed
     */
    public static void forceCloseConnection(Connection con , Statement stmt , ResultSet rs) {
        // Close ResultSet
        if ( rs != null ) {
            try {
                rs.close();
            } catch (SQLException e) {
            }
        }
        // Close Statement
        if ( stmt != null ) {
            try {
                stmt.close();
            } catch (SQLException e) {
            }
        }
        // close Connection
        forceCloseConnection( con );
    }

    /**
     * Sets String parameter to statement, check if paramter is NULL and
     * sets null if it is null
     * @param pStmt Statement
     * @param index parameter index
     * @param value value to set
     * @throws SQLException
     */
    public static void stmtSetString(PreparedStatement pStmt, int index, String value) throws SQLException {
        if (pStmt != null) {
            if (value != null) {
                pStmt.setString(index, value);
            }
            else {
                pStmt.setNull(index, java.sql.Types.VARCHAR);
            }
        }
    }

    /**
     * Sets java.util.Date parameter to statement, check if paramter is NULL and
     * sets null if it is null
     * @param pStmt Statement
     * @param index parameter index
     * @param value value to set
     * @throws SQLException
     */
    public static void stmtSetDate(PreparedStatement pStmt, int index, java.util.Date value) throws SQLException {
        if (pStmt != null) {
            if (value != null) {
                pStmt.setTimestamp(index, new java.sql.Timestamp(value.getTime()));
            } else {
                pStmt.setNull(index, java.sql.Types.DATE);
            }
        }
    }

    /**
     * Sets java.sql.Date parameter to statement, check if paramter is NULL and
     * sets null if it is null
     * @param pStmt Statement
     * @param index parameter index
     * @param value value to set
     * @throws SQLException
     */
    public static void stmtSetDate(PreparedStatement pStmt, int index, java.sql.Date value) throws SQLException {
        if (pStmt != null) {
            if (value != null) {
                pStmt.setDate(index, value);
            }
            else {
                pStmt.setNull(index, java.sql.Types.DATE);
            }
        }
    }

    /**
     * Sets long parameter to statement
     * @param pStmt Statement
     * @param index parameter index
     * @param value value to set
     * @throws SQLException
     */
    public static void stmtSetLong(PreparedStatement pStmt, int index, long value) throws SQLException {
        if (pStmt != null) {
            pStmt.setLong(index, value);
        }
    }
    /**
     * Sets Long parameter to statement
     * @param pStmt Statement
     * @param index parameter index
     * @param value value to set
     * @throws SQLException
     */
    public static void stmtSetLong(PreparedStatement pStmt, int index, Number value) throws SQLException {
        if (pStmt != null) {
            if (value != null) {
                pStmt.setLong(index, value.longValue());
            }
            else {
                pStmt.setNull(index, java.sql.Types.INTEGER);
            }
        }
    }
    /**
     * Sets int parameter to statement
     * @param pStmt Statement
     * @param index parameter index
     * @param value value to set
     * @throws SQLException
     */
    public static void stmtSetInt(PreparedStatement pStmt, int index, int value) throws SQLException {
        if (pStmt != null) {
            pStmt.setInt(index, value);
        }
    }

    /**
     * Sets Integer parameter to statement
     * @param pStmt Statement
     * @param index parameter index
     * @param value value to set
     * @throws SQLException
     */
    public static void stmtSetInt(PreparedStatement pStmt, int index, Number value) throws SQLException {
        if (pStmt != null) {
            if (value != null) {
                pStmt.setInt(index, value.intValue());
            }
            else {
                pStmt.setNull(index, java.sql.Types.INTEGER);
            }
        }
    }

    /**
     * Sets double parameter to statement
     * @param pStmt Statement
     * @param index parameter index
     * @param value value to set
     * @throws SQLException
     */
    public static void stmtSetDouble(PreparedStatement pStmt, int index, double value) throws SQLException {
        if (pStmt != null) {
            pStmt.setDouble(index, value);
        }
    }

    /**
     * Sets Double parameter to statement
     * @param pStmt Statement
     * @param index parameter index
     * @param value value to set
     * @throws SQLException
     */
    public static void stmtSetDouble(PreparedStatement pStmt, int index, Number value) throws SQLException {
        if (pStmt != null) {
            if (value != null) {
                pStmt.setDouble(index, value.doubleValue());
            }
            else {
                pStmt.setNull(index, java.sql.Types.DOUBLE);
            }
        }
    }

}
