/*
 * Developed by eVelopers Corporation
 *
 * $Date: 19-Jul-05 13:22:58$
 *
 */
package com.evelopers.common.util.csv.validators;

import java.util.Properties;
import java.text.SimpleDateFormat;
import java.text.ParseException;
import java.util.regex.*;

import com.evelopers.common.exception.ValidationError;
import com.evelopers.common.util.csv.TokenValidator;
import com.evelopers.common.util.csv.TokenValidatorUtils;

/**
 * TO BE DOCUMENTED!
 *
 * @author: aloukianova
 * @version $Revision: 1$
 */
public class MaskValidator extends TokenValidator {
    public static final String FORMAT = "format";

    /**
     * @see com.evelopers.common.util.csv.TokenValidator#validate(java.lang.String, java.lang.String, java.util.Map)
     */
    public void validate(String test, String token, Properties parameters)
            throws ValidationError {
        boolean resultOK = true;
        if (test.equals(TokenValidatorUtils.DATE)) {
            resultOK = validateDate(token, parameters);
        } else if (test.equals(TokenValidatorUtils.MASK)) {
            resultOK = validateMask(token, parameters);
        } else {
            throw new ValidationError(ValidationError.TEST_NOT_IMPLEMENTED, test);
        }
        if (!resultOK)
            throw new ValidationError(test, token);
    }
    
    protected boolean validateDate(String token, Properties parameters) {

        String datePattern = parameters.getProperty(FORMAT);
        
        if (token == null || datePattern == null || datePattern.length() <= 0) 
            return false;

        SimpleDateFormat formatter = new SimpleDateFormat(datePattern);
        formatter.setLenient(false);

        try {
            formatter.parse(token);
        } catch(ParseException e) {
            return false;
        }
        
        return true;
    }

    protected boolean validateMask(String token, Properties parameters) {

        String mask = parameters.getProperty(FORMAT);
        
        if (mask == null || mask.length() <= 0) {
            return false;
        }

        Pattern pattern = Pattern.compile(mask);
        Matcher matcher = pattern.matcher(token);
        return matcher.matches();
        
    }
}
