/*
 * Developed by eVelopers Corporation
 *
 * Copyright (c) 2005 eVelopers Corporation. All rights reserved.
 * This software is the confidential and proprietary information of
 * eVelopers Corporation. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of
 * the license agreement you entered into with eVelopers.
 *
 * $Created: 06.07.2005$
 */
package com.evelopers.common.util.csv.iterator;

import java.sql.*;
import java.util.*;

import com.evelopers.common.exception.*;
import com.evelopers.common.util.db.SQLUtil;

/**
 * ResultSetIterator is a wrapper for result set
 * providing ability to get lines of data iteratively. Line may 
 * be stored in the bean (getObject method) or 
 *
 * @author aloukianova
 */
public class ResultSetIterator implements ExportIterator {
    
    ResultSet resultSet;    
    ResultSetMetaData metadata;
    //Connection connection;
    String[] format;

    /**
     * 
     */
    public ResultSetIterator(ResultSet resultSet/*, Connection connection*/) {
        super();
        this.resultSet = resultSet;        
        //this.connection = connection;
        
        try {
	        metadata = resultSet.getMetaData();
	        if (metadata == null || metadata.getColumnCount() == 0) {
	            format = new String[0];
	            return;
	    	}
	        
	        format = new String[metadata.getColumnCount()];
	        for (int i = 0; i < format.length; i++) {
	            try {
	                format[i] = metadata.getColumnName(i+1);
	            } catch (SQLException sqle) {
	                sqle.printStackTrace(System.err);
	            }
	        }
        } catch (SQLException sqle) {
            sqle.printStackTrace(System.err);
        }
    }
    
    /** 
     * Not Implemented for this ExportIterator. Use {@link next()} instead.
     * 
     * @see com.evelopers.common.util.csv.ExportIterator#first()
     */
    public Object next(Class beanClass) throws CommonException {
        throw new SystemException("Not Implemented");
    }

    /**
     * Returns next line in <code>property_name(String):proeprty_value(Object)</code> 
     * pairs.
     * Returns <code>null</code> if no next line available (end of list).
     * 
     * @see com.evelopers.common.util.csv.iterator.ExportIterator#getValues(java.lang.String[])
     */
    public Map next() throws CommonException {        
        try {
            /*ResultSetMetaData metadata = resultSet.getMetaData();
            if (metadata == null || metadata.getColumnCount() == 0)        
                return null;*/
            if (!resultSet.next()) return null;
            
            Map values = new HashMap(format.length);
	        for (int i = 0; i < format.length; i++) {	            
	            values.put(format[i], resultSet.getObject(format[i]));
	        }
	        return values;
        } catch (SQLException e) {
            throw new SystemException(e, e.getMessage());
        }        
    }

    /* 
     * @see com.evelopers.common.util.csv.ExportIterator#close()
     */
    public void close() throws CommonException {
        try {
            SQLUtil.closeConnection(resultSet);
        } catch (SQLException e) {
            throw new SystemException(e, e.getMessage());
        }
    }

    /**
     * Returns column names got from metha data of the result set.
     */
    public String[] getHeaders() throws CommonException {
        try {
            String[] headers = new String[resultSet.getMetaData().getColumnCount()];
            
            for (int i = 0; i < resultSet.getMetaData().getColumnCount(); i++) 
                headers[i] = resultSet.getMetaData().getColumnName(i);
            
            return headers;
        } catch (SQLException e) {
            throw new SystemException(e, e.getMessage());
        }
    }
}
