/*
 * Developed by eVelopers Corporation
 *
 * Copyright (c) 2005 eVelopers Corporation. All rights reserved.
 * This software is the confidential and proprietary information of
 * eVelopers Corporation. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of
 * the license agreement you entered into with eVelopers.
 *
 * $Created: 06.07.2005$
 */
package com.evelopers.common.util.csv.iterator;

import java.util.Map;

import com.evelopers.common.exception.CommonException;

/**
 * TODO Document ExportIterator
 *
 * @author aloukianova
 */
public interface ExportIterator {
    
    /**
     * Returns next object to be exported or null of 
     * no more objects in the list.
     *
     * @param beanClass of object to return
     * @return next object to export
     * @throws CommonException
     */
    public Object next(Class beanClass) throws CommonException;
    
    /**
     * Returns map containing <code>property_name:property_value</code> pairs. 
     * Property values are objects of type String, Timestamp, Boolean, 
     * Array, Integer, Double, etc. 
     *
     * @return next values to export
     * @throws CommonException
     */
    public Map next()throws CommonException;
    
    /**
     * Closes resources. Like result set or database 
     * connection for ResultSetIterator.
     *
     * @throws CommonException
     */
    public void close() throws CommonException;
    
    public String[] getHeaders() throws CommonException;
}
