/*
 * Developed by eVelopers Corporation
 *
 * $Date: 19-Jul-05 13:23:02$
 *
 */
package com.evelopers.common.util.csv;

import org.apache.commons.collections.FastHashMap;
import com.evelopers.common.util.csv.validators.*;

/**
 * @author: aloukianova
 * @version $Revision: 1$
 */
public class TokenValidatorUtils {
    
    public static final String REQUIRED = "required"; 
    public static final String MIN_LENGTH = "minLength"; 
    public static final String MAX_LENGTH = "maxLength"; 
    public static final String MASK = "mask"; 
    public static final String BYTE = "byte"; 
    public static final String SHORT = "short"; 
    public static final String INTEGER = "integer"; 
    public static final String LONG = "long"; 
    public static final String FLOAT = "float"; 
    public static final String DOUBLE = "double"; 
    public static final String DATE = "date"; 
    public static final String INT_RANGE = "intRange"; 
    public static final String FLOAT_RANGE = "floatRange"; 
    public static final String DOUBLE_RANGE = "doubleRange"; 
    
    /**
     * The set of {@link TokenValidator}s that can be used to check tokens.
     * using various tests, keyed by the destination test.
     */
    private static FastHashMap validators = new FastHashMap();

    static {
        validators.setFast(false);
        deregister();
        validators.setFast(true);
    }

    /**
     * Remove all registered validators, and re-establish the
     * standard validators.
     */
    public static void deregister() {
        validators.clear();
        
        SimpleTypeValidator stv = new SimpleTypeValidator();
        validators.put(BYTE, stv);
        validators.put(SHORT, stv);
        validators.put(INTEGER, stv);
        validators.put(LONG, stv);
        validators.put(FLOAT, stv);
        validators.put(DOUBLE, stv);
        
        MaskValidator mv = new MaskValidator();
        validators.put(MASK, mv);
        validators.put(DATE, mv);
        
        GenericValidator gv = new GenericValidator();
        validators.put(REQUIRED, gv);
        validators.put(MAX_LENGTH, gv);
        validators.put(MIN_LENGTH, gv);
        validators.put(INT_RANGE, gv);
        validators.put(FLOAT_RANGE, gv);
        validators.put(DOUBLE_RANGE, gv);
    }
    
    /**
     * Look up and return any registered {@link Converter} for the specified
     * destination class; if there is no registered Converter, return
     * <code>null</code>.
     *
     * @param test test for which to return a registered TokenValidator
     */
    public static TokenValidator lookup(String test) {
        return ((TokenValidator) validators.get(test));
    }


    /**
     * Register a custom {@link TokenValidator} for the specified destination
     * <code>test</code>, replacing any previously registered validators.
     *
     * @param converter TokenValidator to be registered
     * @param test Destination test performed by this validator
     */
    public static void register(TokenValidator validator, String test) {
        validators.put(test, validator);
    }
}
