/*
 * Developed by eVelopers Corporation
 *
 * Copyright (c) 1999-2002 eVelopers Corporation. All rights reserved.
 * This software is the confidential and proprietary information of
 * eVelopers Corporation. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of
 * the license agreement you entered into with eVelopers.
 *
 * $Date: 26-Jun-03 15:52:11$
 *
 */
package com.evelopers.common.util.csv;

import com.evelopers.common.util.helper.*;
import java.util.*;

/**
 * Utility class for decoding comma separated values (CSV) streams.
 *
 * @author magus
 * @version $Revision: 1$
 */
public class CSVDecoder {

  /**
   * Private constructor deny to create instcance of this class.
   */
  private CSVDecoder() {
  }

  /**
   * Delimeter for CSV streams
   */
  public static final char SCSV_DELIMETER = ',';

  private static final int SCSV_COND_IN_USUAL_TOKEN = 0x00000010;
  private static final int SCSV_COND_IN_ESCAPED_TOKEN = 0x00000020;
  private static final int SCSV_COND_ON_FIRST_ESCAPE = 0x00000040;
  private static final int SCSV_STATE_ON_DELIMETER = 0x00000002;
  private static final int SCSV_STATE_IN_TOKEN = 0x00000001;
  private static final char SCSV_ESCAPE = '\"';
  // For speed up
  private static final String strDoubleEscape = "" + SCSV_ESCAPE + SCSV_ESCAPE;
  private static final String strEscape = "" + SCSV_ESCAPE;

  /**
   * <b>DRAFT VERSION.</b>
   * Splits csv string by the ',' symbol. Also, it checks for "\"" container symbols
   * at the start and at the end of block.
   *
   * @param csvText text to split
   * @return array of string extracted from given csv string
   */
  public static String[] splitCSVString(String csvText) {
    char[] cText = csvText.toCharArray();
    int cTextIndex = 0;
    List tokens = new ArrayList();
    int condition = 0;
    int state = SCSV_STATE_ON_DELIMETER;
    int startPos = 0;
    while (true) {
      if (cTextIndex >= cText.length) {
	if (state == SCSV_STATE_ON_DELIMETER) {
	  // the last symbol is delimeter
	  tokens.add(new String(""));
	} else
	if (cTextIndex - 1 >= startPos) {
	  if ((condition & SCSV_COND_IN_ESCAPED_TOKEN) != 0) {
	    if ((condition & SCSV_COND_ON_FIRST_ESCAPE) != 0) {
	      // the last symbol is "escape"
	      tokens.add(new String(cText, startPos + 1,
				    cTextIndex - startPos - 2));
	    } else {
	      // It is incorrect situation like thius: "xxx,xxx,\"zzz". I.e. we have an escaped token
	      // without escape symbol at has end. So, let's don't remove the leading escape!!!
	      tokens.add(new String(cText, startPos, cTextIndex - startPos));
	    }

	  } else {
	    tokens.add(new String(cText, startPos, cTextIndex - startPos));
	  }
	}
	break;
      }
      switch (state) {
	case SCSV_STATE_ON_DELIMETER:
	  if (cText[cTextIndex] == SCSV_DELIMETER) {
	    // Empty token
	    tokens.add("");
	    state = SCSV_STATE_ON_DELIMETER;
	  } else
	  if (cText[cTextIndex] == SCSV_ESCAPE) {
	    // token starts from escape symbol
	    state = SCSV_STATE_IN_TOKEN;
	    condition = SCSV_COND_IN_ESCAPED_TOKEN;
	    startPos = cTextIndex;
	    //cTextIndex++; // miss the first escape of the token
	  } else {
	    state = SCSV_STATE_IN_TOKEN;
	    condition = SCSV_COND_IN_USUAL_TOKEN;
	    startPos = cTextIndex;
	  }
	  break;
	case SCSV_STATE_IN_TOKEN:
	  if ((condition & SCSV_COND_IN_USUAL_TOKEN) != 0) {
	    if (cText[cTextIndex] == SCSV_DELIMETER) {
	      // the delimeter after usual token
	      tokens.add(new String(cText, startPos, cTextIndex - startPos));
	      state = SCSV_STATE_ON_DELIMETER;
	      condition = 0;
	    }
	  } else
	  if ((condition & SCSV_COND_IN_ESCAPED_TOKEN) != 0) {
	    if ((condition & SCSV_COND_ON_FIRST_ESCAPE) != 0) { // Previous char is '\"'
	      condition ^= SCSV_COND_ON_FIRST_ESCAPE; // Reset flag
	      if (cText[cTextIndex] == SCSV_ESCAPE) {
		// It is simply the escaped escape
	      } else if (cText[cTextIndex] == SCSV_DELIMETER) {
		// it is the end of token
		//tokens.add( new String(cText , startPos , cTextIndex - startPos) );
		tokens.add(new String(cText, startPos + 1,
				      cTextIndex - startPos - 2));
		state = SCSV_STATE_ON_DELIMETER;
		condition = 0;
	      }
	    } else if (cText[cTextIndex] == SCSV_ESCAPE) {
	      // the delimeter after usual token
	      //tokens.addElement(new String(cText , startPos , cTextIndex - startPos));
	      condition |= SCSV_COND_ON_FIRST_ESCAPE;
	    }
	  }
	  break;
      }
      cTextIndex++;
    }
    String[] result = new String[tokens.size()];
    for (int i = 0; i < tokens.size(); i++) {
      result[i] = (String)tokens.get(i);
      result[i] = StringHelper.replaceAll(result[i], strDoubleEscape, strEscape);
    }
    return result;
  }

}
