/*
 * Developed by eVelopers Corporation
 *
 * Copyright (c) 1999-2003 eVelopers Corporation. All rights reserved.
 * This software is the confidential and proprietary information of
 * eVelopers Corporation. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of
 * the license agreement you entered into with eVelopers.
 *
 * $Date: 23-Mar-05 12:44:04$
 *
 */
package com.evelopers.common.util.collection;

import java.util.*;


/**
 * TO BE DOCUMENTED!
 *
 * Author: L.V.A
 * @version $Revision: 1$
 */
public class MultiHashMap extends HashMap {

    // ----------------- Data
    private static int sCount = 0;
    private String mName = null;

    /**
     * TO BE DOCUMENTED!
     *
     */
    public MultiHashMap(  ) {
        super(  );
        setName(  );
    }

    /**
     * TO BE DOCUMENTED!
     *
     *
     * @param <code>initialCapacity</code>
     */
    public MultiHashMap( int initialCapacity ) {
        super( initialCapacity );
        setName(  );
    }

    /**
     * TO BE DOCUMENTED!
     *
     *
     * @param <code>initialCapacity</code>
     * @param <code>loadFactor</code>
     */
    public MultiHashMap( int initialCapacity, float loadFactor ) {
        super( initialCapacity, loadFactor );
        setName(  );
    }

    /**
     * TO BE DOCUMENTED!
     *
     *
     * @param <code>mapToCopy</code>
     */
    public MultiHashMap( Map mapToCopy ) {
        super( mapToCopy );
    }

    private void setName(  ) {

        sCount++;
        mName = "MultiMap-" + sCount;
    }

    /**
     * TO BE DOCUMENTED!
     *
     * @return
     */
    public String getName(  ) {

        return mName;
    }

    /**
     * TO BE DOCUMENTED!
     *
     * @param <code>key</code>
     * @param <code>value</code>
     * @return
     */
    public Object put( Object key, Object value ) {

        // NOTE:: put might be called during deserialization !!!!!!
        // so we must provide a hook to handle this case
        // This means that we cannot make MultiMaps of ArrayLists !!!
        if ( value instanceof ArrayList ) {

            return ( super.put( key, value ) );
        }

        ArrayList keyList = ( ArrayList ) ( super.get( key ) );

        if ( keyList == null ) {

            keyList = new ArrayList( 10 );

            super.put( key, keyList );
        }

        boolean results = keyList.add( value );

        return ( results ? value : null );
    }

    /**
     * TO BE DOCUMENTED!
     *
     * @param <code>value</code>
     * @return
     */
    public boolean containsValue( Object value ) {

        Set pairs = super.entrySet(  );

        if ( pairs == null ) {

            return false;
        }

        Iterator pairsIterator = pairs.iterator(  );

        while ( pairsIterator.hasNext(  ) ) {

            Map.Entry keyValuePair = ( Map.Entry ) ( pairsIterator.next(  ) );
            ArrayList list = ( ArrayList ) ( keyValuePair.getValue(  ) );

            if ( list.contains( value ) ) {

                return true;
            }
        }

        return false;
    }

    /**
     * TO BE DOCUMENTED!
     *
     * @param <code>value</code>
     * @return
     */
    public int removeValue( Object value ) {

        int removed = 0;

        Set pairs = super.entrySet(  );

        if ( pairs != null ) {

            for ( Iterator i = pairs.iterator(  ); i.hasNext(  ); ) {

                Map.Entry keyValuePair = ( Map.Entry ) ( i.next(  ) );

                ArrayList list = ( ArrayList ) ( keyValuePair.getValue(  ) );

                // We cannot make MultiMaps of ArrayLists so just delete this key
                if ( value instanceof ArrayList ) {

                    if ( value.equals( list ) ) {

                        super.remove( keyValuePair.getKey(  ) );
                        removed++;
                    }
                } else { // Remove value from ArrayList

                    while ( list.remove( value ) ) {

                        removed++;
                    }

                    if ( list.size(  ) == 0 ) { // If this ArrayList is empty after value removal remove the key
                        super.remove( keyValuePair.getKey(  ) );
                    }
                }
            }
        }

        return removed;
    }

    /**
     * TO BE DOCUMENTED!
     *
     * @param <code>key</code>
     * @param <code>item</code>
     * @return
     */
    public Object remove( Object key, Object item ) {

        ArrayList valuesForKey = ( ArrayList ) super.get( key );

        if ( valuesForKey == null ) {

            return null;
        }

        valuesForKey.remove( item );

        return item;
    }

    /**
     * TO BE DOCUMENTED!
     *
     */
    public void clear(  ) {

        Set pairs = super.entrySet(  );
        Iterator pairsIterator = pairs.iterator(  );

        while ( pairsIterator.hasNext(  ) ) {

            Map.Entry keyValuePair = ( Map.Entry ) ( pairsIterator.next(  ) );
            ArrayList list = ( ArrayList ) ( keyValuePair.getValue(  ) );
            list.clear(  );
        }

        super.clear(  );
    }

    /**
     * TO BE DOCUMENTED!
     *
     * @param <code>mapToPut</code>
     */
    public void putAll( Map mapToPut ) {

        super.putAll( mapToPut );
    }

    /**
     * TO BE DOCUMENTED!
     *
     * @return
     */
    public Collection values(  ) {

        ArrayList returnList = new ArrayList( super.size(  ) );

        Set pairs = super.entrySet(  );
        Iterator pairsIterator = pairs.iterator(  );

        while ( pairsIterator.hasNext(  ) ) {

            Map.Entry keyValuePair = ( Map.Entry ) ( pairsIterator.next(  ) );
            ArrayList list = ( ArrayList ) ( keyValuePair.getValue(  ) );

            Object[] values = list.toArray(  );

            for ( int ii = 0; ii < values.length; ii++ ) {

                returnList.add( values[ ii ] );
            }
        }

        return returnList;
    }

    // FIXME:: do we need to implement this??
    // public boolean equals( Object obj ) {}
    // --------------- From Cloneable

    /**
     * TO BE DOCUMENTED!
     *
     * @return
     */
    public Object clone(  ) {

        MultiHashMap obj = ( MultiHashMap ) ( super.clone(  ) );
        obj.mName = mName;

        return obj;
    }
}
