/*
 * Developed by eVelopers Corporation
 *
 * Copyright (c) 1999-2002 eVelopers Corporation. All rights reserved.
 * This software is the confidential and proprietary information of
 * eVelopers Corporation. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of
 * the license agreement you entered into with eVelopers.
 *
 * $Date: 10-Jul-03 15:50:50$
 *
 */
package com.evelopers.common.exception;

/**
  * Component throws this exception in case of unrecovered situation from the component
  * point of view. Component container depending of it's own logic may interpret
  * this exception either as system or as logic. Also container may try to
  * restore component state.
  *
  * @author kex
  * @version $Revision: 4$
  * @see com.evelopers.common.exception.CommonException
  */
public class SystemException extends CommonException {

    /**
     * @see CommonException#CommonException(String)
     * @param message error message
     */
    public SystemException(String message) {
        super(message);
    }

    /**
     * @see CommonException#CommonException(Throwable)
     * @param e original exception
     */
    public SystemException(Throwable e) {
        super(e);
    }

    /**
     * @see CommonException#CommonException(Throwable, String)
     * @param e original exception
     * @param message error message
     */
    public SystemException(Throwable e, String message) {
        super(e, message);
    }

}


/*--- ///:~ ---*/
