/*
 * Developed by eVelopers Corporation
 *
 * $Date: 18-Feb-04 13:14:03$
 *
 */

package com.evelopers.common.cache;

import org.apache.commons.collections.map.ReferenceMap;
import com.evelopers.common.concurrent.RWLock;

/**
 * <p>This class implements memory sensitive cache with separate read/write locks
 * ({@link com.evelopers.common.RWLock}) to increase performance. Memory sensitivity
 * is implemented using "soft" references.</p>
 *
 * Author: L.V.A
 * @version $Revision: 1$
 */
public class MemSensitiveCache {

    private ReferenceMap cache;
    private RWLock lock;

    public MemSensitiveCache() {
        cache = new ReferenceMap();
        lock = new RWLock();
    }

    /**
     * Gets object from cache
     *
     * @param <code>key</code>
     * @return
     */
    public Object get(Object key) {

        if (lock.getReadLock()) {
            try {
                return cache.get(key);
            } finally {
                lock.releaseLock();
            }
        }
        return null;
    }

    /**
     * Cache object
     *
     * @param <code>key</code>
     * @param <code>value</code>
     */
    public void put(Object key, Object value) {

        if (lock.getWriteLock()) {
            try {
                cache.put(key, value);
            } finally {
                lock.releaseLock();
            }
        }
    }

}
