header {
/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.runtime.interpretation;

}

{
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.parser.ConstNode;
import com.evelopers.unimod.parser.IdentNode;
import com.evelopers.unimod.parser.InterpreterException;
import com.evelopers.unimod.runtime.context.StateMachineContext;
}

/**
 * AST Tree Interpreter
 */
class GuardInterpreter extends TreeParser;
options {
	importVocab=Expr;
}

{
	private CalculatedInputActions inputActions;
	private StateMachineContext context;

	/**
	  * Interpret expression of given guard.
	  * Returns "true" if given Guard is {@link com.evelopers.unimod.core.stateworks.Guard#ELSE}.
	  */
	public static boolean interpret(Guard c, StateMachineContext context,
	                                CalculatedInputActions inputActions)
	                                throws InterpreterException {
		if (c.equals(Guard.ELSE)) {
			return true;
		}

		return interpret(c.getAST(), context, inputActions);
	}
	
	/**
	  * Interpret expression of given guard.
	  * Returns "true" if given Guard is {@link com.evelopers.unimod.core.stateworks.Guard#ELSE}.
	  * TODO: make pool of interpreters
	  */
	public static boolean interpret(AST ast, StateMachineContext context,
	                                CalculatedInputActions inputActions)
	                                throws InterpreterException {
		try {
			GuardInterpreter i = new GuardInterpreter();
			i.setInputActions(inputActions);
			i.setContext(context);
			return i.s(ast);
		} catch (RecognitionException e) {
			throw new InterpreterException(e);
		} 
	}
	
	private void setInputActions(CalculatedInputActions inputActions) {
	    this.inputActions = inputActions;
	}

	private void setContext(StateMachineContext context) {
	    this.context = context;
	}
}

s returns [boolean r] throws InterpreterException {
	boolean a, b;
    int i, j;
	r = false; 
} : #(OR     a = s  b = s)   {r = a || b;}
  | #(AND    a = s  b = s)   {r = a && b;}
  | #(NOT    a = s)          {r = !a;}

  | #(EQUAL  i = i5  j = i5) {r = i == j;}
  | #(NEQUAL i = i5  j = i5) {r = i != j;}
  | #(GE     i = i5  j = i5) {r = i >= j;}
  | #(GT     i = i5  j = i5) {r = i >  j;}
  | #(LE     i = i5  j = i5) {r = i <= j;}
  | #(LT     i = i5  j = i5) {r = i <  j;}

  | id:IDENT                 {r = inputActions.getBool(((IdentNode)id).getAction(), context);}
  | TRUE                     {r = true;}
  | FALSE                    {r = false;}
  ;

i5 returns [int r] throws InterpreterException {
	r = 0;
} : id:IDENT                 {r = inputActions.getNum(((IdentNode)id).getAction(), context);}
  | c:CONST_NUM              {r = ((ConstNode)c).getValue();}
  ;
