header {
/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.parser;

}

class Infix extends TreeParser;
options {
	importVocab=Expr;
}

{
	public static String infix(AST ast) throws InterpreterException {
		try {
			Infix i = new Infix();
		
			return i.formula(ast);
		} catch (RecognitionException e) {
			throw new InterpreterException(e);
		} 
	}
}


formula returns [String str] {
    str = "";
} : str = dis
  | str = term
  ;

term returns [String str] {
    str = "";
} : str = con
  | str = lit
  ;

lit returns [String str] {
    str = "";
} : str = neg
  | str = cmp
  | str = val
  ;

dis returns [String str] {
    str = "";
    String a;
} : #(OR
        (a = formula {str += (str.length() > 0 ? " || " : "") + a;})+
     )
  ;

con returns [String str] {
    str = "";
    String a;
} : #(AND
        ( (a = dis     {str += (str.length() > 0 ? " && (" : "(") + a + ")";})
        | (a = term    {str += (str.length() > 0 ? " && "  : "" ) + a;})
        )+
      )
  ;

neg returns [String str] {
    str = "";
    String a;
} : #(NOT
        ( (a = dis     {str = "!(" + a + ")";})
        | (a = con     {str = "!(" + a + ")";})
        | (a = lit     {str = "!" + a;})
        )
     )
  ;

cmp returns [String str] {
    str = "";
    String a, b;
} : #(EQUAL  a = val  b = val)   {str = a + " == " + b;}
  | #(NEQUAL a = val  b = val)   {str = a + " != " + b;}
  | #(GE     a = val  b = val)   {str = a + " >= " + b;}
  | #(GT     a = val  b = val)   {str = a + " > "  + b;}
  | #(LE     a = val  b = val)   {str = a + " <= " + b;}
  | #(LT     a = val  b = val)   {str = a + " < "  + b;}
  ;

val returns [String str] {
    str = "";
} : i:IDENT            {str = i.getText();}
  | c:CONST_NUM        {str = c.getText();}
  |   TRUE             {str = "true";}
  |   FALSE            {str = "false";}
  ;
