header {
/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.parser;

}

{
import java.io.*;
import java.util.*;
import com.evelopers.unimod.core.stateworks.*;
import com.evelopers.unimod.compilation.*;
import antlr.*;
import com.evelopers.unimod.compilation.OperationResolver;
}

/**
 * Logic Expression Parser for Guard {@link com.evelopers.unimod.core.stateworks.Guard}
 * 
 */
class ExprParser extends Parser;
options {
	buildAST = true;	// uses CommonAST by default
	k = 2;
	exportVocab=Expr;
	defaultErrorHandler = false;
}

tokens {
	TRUE;
	FALSE;
}

{
	private StateMachine sm = null;
	private OperationResolver operationResolver = null;

    static {
        try {
            ExprParser.class.forName("com.evelopers.unimod.parser.IdentNode");
            ExprParser.class.forName("com.evelopers.unimod.parser.ConstNode");
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

	public void setStateMachine(StateMachine sm) {
		this.sm = sm;
	}
	
	public void setOperationResolver(OperationResolver operationResolver) {
		this.operationResolver = operationResolver;
	}

	public static AST parse(String expr, StateMachine sm, OperationResolver operationResolver) throws ParserException {
		try {
			ExprParser p = new ExprParser(new ExprLexer(new StringReader(expr)));
			p.setStateMachine(sm);
			p.setOperationResolver(operationResolver);
			p.s();
			return p.getAST();
		} catch (RecognitionException e) {
			throw new ParserException(e.getMessage(), e.getColumn());
		} catch (TokenStreamRecognitionException e) {
			throw new ParserException(e.getMessage(), e.recog.getColumn());
		} catch (TokenStreamException e) {
			throw new ParserException(e);
		}
 	} 
 	
 	private void assertCOExists(Token i) throws ParserException {
 		if (sm.getControlledObjectHandler(StateMachineCompiler.getObjectName(i.getText())) == null) {
 		    throw new UndefinedControlledObjectHandlerException(StateMachineCompiler.getObjectName(i.getText()), i.getColumn());
 		};
 	}
 	
	private void assertReturnType(Token i, Class returnType) throws ParserException {
		if (operationResolver == null) {
			return;
		}
		String ident = i.getText();
		int position = i.getColumn();
        ControlledObjectHandler co = sm.getControlledObjectHandler(StateMachineCompiler.getObjectName(ident));
        // if co is null - assertCOExists will rise exception that will be enougth
        if (co == null) {
        	return;
        }
        
        String actionName = StateMachineCompiler.getActionName(ident);
        Class type = operationResolver.getOperationType(co, actionName);
        if (type == null) {
            throw new UndefinedActionException(co, actionName, position);
        }
        if (! returnType.isAssignableFrom(type)) {
            throw new ActionTypeMismatchException(co, actionName, returnType, type, position);
        }
	}
 	
}

s  throws ParserException : s1 EOF!;

s1 throws ParserException : i1 (OR^ i1)*;

i1 throws ParserException : i2 (AND^ i2)*;

i2 throws ParserException : (NOT NOT) => NOT! NOT! i2 | 
	 NOT^ i3 |
     i3;

i3 throws ParserException : LPAREN! s1 RPAREN! | 
     i4;

i4 throws ParserException : i5 (EQUAL^ | NEQUAL^ | GE^ | GT^ | LE^ | LT^) i5 | 
     i:IDENT<AST=com.evelopers.unimod.parser.IdentNode> 
     {assertCOExists(i);
      assertReturnType(i, Boolean.class);
      #i.setAction(sm, sm.createAction(i.getText()), Boolean.class);} |
     c:CONST_BOOL { #c.setType("true".equalsIgnoreCase(c.getText()) ? TRUE : FALSE); };

i5 throws ParserException : i:IDENT<AST=com.evelopers.unimod.parser.IdentNode> 
     {assertCOExists(i);
      assertReturnType(i, Integer.class);
      #i.setAction(sm, sm.createAction(i.getText()), Integer.class);} |
     CONST_NUM<AST=com.evelopers.unimod.parser.ConstNode>;

/**
 * Lexic parser
 */
class ExprLexer extends Lexer;
options {
	caseSensitive=true;
	k = 2;
}

WS : (' ' | '\t' | '\n' | '\r')
  { _ttype = Token.SKIP; };

LPAREN : '(';
RPAREN : ')';
NOT    : '!';
AND    : "&&";
OR     : "||";

EQUAL  : "==";
NEQUAL : "!=";
GE     : ">=";
GT     : '>';
LE     : "<=";
LT     : '<';

protected
DIGIT:  '0'..'9';

protected
LETTER: 'A'..'Z' | 'a'..'z';

protected
CONST_BOOL: ("true" | "false");

protected
NAME: (LETTER | '_')(LETTER | DIGIT | '_')*;

protected
IDENT: NAME  '.' NAME;

CONST_NUM: ('-')? (DIGIT)+;

CONST_BOOL_OR_IDENT
    : ("false") => CONST_BOOL {$setType(CONST_BOOL);}
    | ("true") => CONST_BOOL {$setType(CONST_BOOL);}
    | (NAME '.') => IDENT {$setType(IDENT);}
    ;

