header {
/*
 *   Copyright (c) 1999-2004 eVelopers Corporation. All rights reserved.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package com.evelopers.unimod.parser;

}

{
import java.util.*;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.parser.ConstNode;
import com.evelopers.unimod.parser.IdentNode;
import com.evelopers.unimod.parser.InterpreterException;
import com.evelopers.unimod.runtime.context.StateMachineContext;
}

/**
 * AST Tree Action Collector
 */
class ActionCollector extends TreeParser;
options {
	importVocab=Expr;
}

{
	private Set inputActions = new HashSet();

	/**
	* returns set of output actions found in given AST
	*/
	public static Set collect(AST ast) throws InterpreterException {
		try {
			ActionCollector i = new ActionCollector();
			i.s(ast);
			
			return i.inputActions;
		} catch (RecognitionException e) {
			throw new InterpreterException(e);
		} 
	}

	/**
	* returns set of IdentNodes found in given AST
	*/
	public static Set collectIdentNodes(AST ast) throws InterpreterException {
		try {
			ActionCollector i = new ActionCollector();
			i.s_(ast);
			
			return i.inputActions;
		} catch (RecognitionException e) {
			throw new InterpreterException(e);
		} 
	}
	
}

// collect nodes without types
s :
    #(OR     s   s)
  | #(AND    s   s)
  | #(NOT    s)    

  | #(EQUAL  i5  i5)
  | #(NEQUAL i5  i5)
  | #(GE     i5  i5)
  | #(GT     i5  i5)
  | #(LE     i5  i5)
  | #(LT     i5  i5)

  | TRUE                     
  | FALSE                    

  | id:IDENT                 {inputActions.add(((IdentNode)id).getAction());};

i5 : 
    CONST_NUM          
  | id:IDENT                 {inputActions.add(((IdentNode)id).getAction());};

// collect ident nodes
s_ :
    #(OR     s_   s_)
  | #(AND    s_   s_)
  | #(NOT    s_)    

  | #(EQUAL  i5_  i5_)
  | #(NEQUAL i5_  i5_)
  | #(GE     i5_  i5_)
  | #(GT     i5_  i5_)
  | #(LE     i5_  i5_)
  | #(LT     i5_  i5_)

  | TRUE                     
  | FALSE                    

  | id:IDENT                 {inputActions.add(id);};

i5_ : 
    CONST_NUM          
  | id:IDENT                 {inputActions.add(id);};
    