header {
    package com.evelopers.unimod.analysis;

    import com.evelopers.unimod.analysis.executors.SubstitutionBuilder;
	import com.evelopers.unimod.parser.ConstNode;
}

/**
 * Gathers predicates and boolean variables. Set objectValues to 
 * constant nodes. Use case:
 * <pre><code>
 *   Gatherer gatherer = new Gatherer(typeInfoProvider);
 *   gatherer.gather(ast);
 *   SubstitutionBuilder builder = gatherer.getBuilder();
 *   Substitution substitution = builder.buildSubstitution();
 * </code></pre>
 */
class Gatherer extends TreeParser;
options {
    buildAST = false;
    importVocab = Expr;
	defaultErrorHandler = false;
}

{
	private TypeInfoProvider typeInfoProvider;		
	private SubstitutionBuilder builder;

	public Gatherer(TypeInfoProvider typeInfoProvider) {
		this();
		this.typeInfoProvider = typeInfoProvider;
		this.builder = new SubstitutionBuilder(typeInfoProvider);
	}		
	
	public SubstitutionBuilder getBuilder() {
		return builder;
	}
	
	private void addPredicate(AST predicate) {		
		AST op1 = predicate.getFirstChild();
        AST op2 = op1.getNextSibling();
        String variableName;
        ConstNode constNode;
        if (op1.getType() == IDENT && op2.getType() == CONST_NUM) {
            variableName = op1.getText();
            constNode = (ConstNode) op2;
            builder.addPredicate(predicate.getType(), variableName, constNode.getText());
            constNode.setObjectValue(typeInfoProvider.parseConstant(variableName, constNode.getText()));
        } else if (op2.getType() == IDENT && op1.getType() == CONST_NUM) {
            variableName = op2.getText();
            constNode = (ConstNode) op1;
            builder.addPredicate(getReflected(predicate.getType()), variableName, constNode.getText());
            constNode.setObjectValue(typeInfoProvider.parseConstant(variableName, constNode.getText()));
        } else {
            reportWarning("predicate " + predicate + " skippped");
            variableName = null;
            constNode = null;
        }
	}	
	
	private int getReflected(int type) {
		switch (type) {
			case EQUAL: return EQUAL;
			case NEQUAL: return NEQUAL;
			case GE: return LE;
			case LE: return GE;
			case GT: return LT;
			case LT: return GT;
			default: throw new IllegalArgumentException();
		}
	}
}

gather
    :   #(OR 	(gather)+)
    |   #(AND 	(gather)+)
    |   #(NOT 	(gather) )
    |   eq:	EQUAL 			{addPredicate(eq);}
	| 	ne: NEQUAL 			{addPredicate(ne);}
	| 	ge: GE 				{addPredicate(ge);}
	|   le: LE 				{addPredicate(le);}
	| 	gt: GT 				{addPredicate(gt);}
	|   lt: LT 				{addPredicate(lt);}
    |   id:	IDENT			{builder.addBooleanVar(id.getText());}
    |   (TRUE | FALSE)
    ;
    
