package org.cleversafe.storage.ss.handlers.transactions;

import static org.junit.Assert.assertEquals;

import java.util.List;

import org.cleversafe.layer.grid.DataSlice;
import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.layer.protocol.CommitTransactionRequest;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.exceptions.ProtocolLayerException;
import org.cleversafe.layer.slicestore.SliceStoreTransaction;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreLayerException;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.exceptions.IllegalSessionStateException;
import org.cleversafe.server.exceptions.ServerException;
import org.cleversafe.storage.ss.handlers.HandlerTestBase;
import org.cleversafe.vault.exceptions.VaultException;
import org.junit.Test;

public class CommitTransactionHandlerTest extends HandlerTestBase
{
   public static int transactionId = 0;
   public static int offset = 0;
   public static int count = 10;

   // Creates a request to be used by the handler
   @Override
   protected Request createRequest()
   {
      return new CommitTransactionRequest(transactionId);
   }

   @Test(expected = IllegalSessionStateException.class)
   public final void testRequiresSliceStore() throws ProtocolLayerException,
         SliceStoreLayerException, ServerException, VaultException
   {
      checkRequiresSliceStore();
   }

   @Test
   public final void testService() throws Exception
   {
      ClientSession session = createClientSession();
      session = authenticateSession(session);
      session = addSliceStore(session);

      // Begin session on slice store
      getSliceStore(session).startSession();

      // Begin transaction
      SliceStoreTransaction transaction = getSliceStore(session).createTransaction(transactionId);
      getSliceStore(session).beginTransaction(transaction);
      
      // Write the Slices
      List<SliceName> sliceNames = generateSliceNames(offset, count);
      List<DataSlice> dataSlices = createDataSlices(sliceNames);
      this.getSliceStore(session).write(dataSlices);

      // Make sure slices don't exist until committed
      assertEquals(true, slicesDontExist(getSliceStore(session), sliceNames));
      
      // Commit Transaction
      Response response = this.handler.service(createRequest(), session);
      
      assertEquals(false, response.getExceptionFlag());

      // Verify slices exist      
      assertEquals(true, slicesExist(getSliceStore(session), sliceNames));

      // End session on slice store
      getSliceStore(session).endSession();
   }

}
