package org.cleversafe.storage.ss.handlers.store;

import static org.junit.Assert.assertEquals;

import java.util.UUID;

import org.cleversafe.layer.protocol.BeginSessionRequest;
import org.cleversafe.layer.protocol.EndSessionRequest;
import org.cleversafe.layer.protocol.RemoveStoreRequest;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.server.ClientSession;
import org.cleversafe.storage.ss.handlers.HandlerTestBase;
import org.junit.Test;

public class RemoveStoreHandlerTest extends HandlerTestBase
{
   UUID vaultId = UUID.randomUUID();
   
   // Creates a request to be used by the handler
   @Override
   protected Request createRequest()
   {
      return new RemoveStoreRequest(vaultId);
   }

   @Test
   public final void testService() throws Exception
   {
      ClientSession session = createClientSession();
      session = authenticateSession(session);

      // Create the Store
      Response response = this.sliceServerApp.service(this.makeCreateStoreRequest(vaultId), session);
      assertEquals(false, response.getExceptionFlag());

      // Verify we can create and use the store object      
      this.bindVault(session, vaultId);
      Request request = new BeginSessionRequest();
      response = this.sliceServerApp.service(request, session);
      assertEquals(false, response.getExceptionFlag());
      
      // End session on slice store
      request = new EndSessionRequest();
      response = this.sliceServerApp.service(request, session);
      assertEquals(false, response.getExceptionFlag());
      
      // Remove the Store
      response = this.handler.service(createRequest(), session);
      assertEquals(false, response.getExceptionFlag());
      
      // Verify we can no longer create the store object      
      this.bindVault(session, vaultId);
      request = new BeginSessionRequest();
      response = this.sliceServerApp.service(request, session);
      assertEquals(true, response.getExceptionFlag());
   }

}
