
package org.cleversafe.storage.ss.handlers.slices;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.cleversafe.layer.protocol.ListStopRequest;
import org.cleversafe.layer.protocol.ListStopResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.exceptions.ProtocolLayerException;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreLayerException;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.exceptions.IllegalSessionStateException;
import org.cleversafe.server.exceptions.ServerException;
import org.cleversafe.server.exceptions.UnauthorizedRequestException;
import org.cleversafe.storage.ss.handlers.HandlerTestBase;
import org.cleversafe.vault.exceptions.VaultException;
import org.junit.Test;

public class ListStopHandlerTest extends HandlerTestBase
{
   @Test(expected = IllegalSessionStateException.class)
   public final void testRequiresSliceStore() throws ProtocolLayerException,
         SliceStoreLayerException, ServerException, VaultException
   {
      checkRequiresSliceStore();
   }

   @Test(expected = UnauthorizedRequestException.class)
   public final void testRequiresListPermission() throws Exception
   {
      checkRequiresPermission();
   }

   @Test
   public final void testService() throws Exception
   {
      ClientSession session = createClientSession();
      authenticateSession(session);
      addSliceStore(session);
      addListPermission(session);

      SliceStore sliceStore = getSliceStore(session);

      sliceStore.startSession();

      // Write slices and list begin
      writeSlices(sliceStore, createDataSlices(generateSliceNames(0, 25)));
      sliceStore.listBegin();

      assertTrue(sliceStore.listInProgress());

      // List Stop
      Response response = this.handler.service(createRequest(), session);
      assertTrue(response instanceof ListStopResponse);
      assertFalse(response.getExceptionFlag());

      assertFalse(sliceStore.listInProgress());

      // List begin and list continue
      sliceStore.listBegin();

      assertTrue(sliceStore.listInProgress());
      sliceStore.listContinue();

      // Should be reset because continue should have listed all
      assertFalse(sliceStore.listInProgress());

      response = this.handler.service(createRequest(), session);
      assertTrue(response instanceof ListStopResponse);
      assertFalse(response.getExceptionFlag());

      assertFalse(sliceStore.listInProgress());

      // After list stop
      sliceStore.endSession();
   }

   @Override
   protected Request createRequest()
   {
      return new ListStopRequest();
   }

}
