
package org.cleversafe.storage.ss.handlers.slices;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.cleversafe.layer.protocol.ListInProgressRequest;
import org.cleversafe.layer.protocol.ListInProgressResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.exceptions.ProtocolLayerException;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreLayerException;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.exceptions.IllegalSessionStateException;
import org.cleversafe.server.exceptions.ServerException;
import org.cleversafe.server.exceptions.UnauthorizedRequestException;
import org.cleversafe.storage.ss.handlers.HandlerTestBase;
import org.cleversafe.vault.exceptions.VaultException;
import org.junit.Test;

public class ListInProgressHandlerTest extends HandlerTestBase
{
   @Test(expected = IllegalSessionStateException.class)
   public final void testRequiresSliceStore() throws ProtocolLayerException,
         SliceStoreLayerException, ServerException, VaultException
   {
      checkRequiresSliceStore();
   }

   @Test(expected = UnauthorizedRequestException.class)
   public final void testRequiresListPermission() throws Exception
   {
      checkRequiresPermission();
   }

   @Test
   public final void testService() throws Exception
   {
      ClientSession session = createClientSession();
      authenticateSession(session);
      addSliceStore(session);
      addListPermission(session);

      SliceStore sliceStore = getSliceStore(session);

      sliceStore.startSession();

      // Before write or listBegin
      Response response = this.handler.service(createRequest(), session);
      assertTrue(response instanceof ListInProgressResponse);
      ListInProgressResponse listInProgressResponse = (ListInProgressResponse) response;
      assertFalse(listInProgressResponse.listInProgress());
      assertFalse(response.getExceptionFlag());

      // Write and listBegin
      writeSlices(sliceStore, createDataSlices(generateSliceNames(0, 25)));
      sliceStore.listBegin();

      // After write and listBegin
      response = this.handler.service(createRequest(), session);
      assertTrue(response instanceof ListInProgressResponse);
      listInProgressResponse = (ListInProgressResponse) response;
      assertTrue(listInProgressResponse.listInProgress());
      assertFalse(response.getExceptionFlag());

      // List stop
      sliceStore.listStop();

      // After list stop
      response = this.handler.service(createRequest(), session);
      assertTrue(response instanceof ListInProgressResponse);
      listInProgressResponse = (ListInProgressResponse) response;
      assertFalse(listInProgressResponse.listInProgress());
      assertFalse(response.getExceptionFlag());

      sliceStore.endSession();

      assertFalse(response.getExceptionFlag());

   }

   @Override
   protected Request createRequest()
   {
      return new ListInProgressRequest();
   }
}
