
package org.cleversafe.storage.ss.handlers.slices;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.cleversafe.layer.grid.DataSlice;
import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.layer.protocol.ExistsRequest;
import org.cleversafe.layer.protocol.ExistsResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.exceptions.ProtocolLayerException;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreLayerException;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.exceptions.IllegalSessionStateException;
import org.cleversafe.server.exceptions.ServerException;
import org.cleversafe.server.exceptions.UnauthorizedRequestException;
import org.cleversafe.storage.ss.handlers.HandlerTestBase;
import org.cleversafe.vault.exceptions.VaultException;
import org.junit.Test;

public class ExistsHandlerTest extends HandlerTestBase
{
   @Test(expected = IllegalSessionStateException.class)
   public final void testRequiresSliceStore() throws ProtocolLayerException,
         SliceStoreLayerException, ServerException, VaultException
   {
      checkRequiresSliceStore();
   }

   @Test(expected = UnauthorizedRequestException.class)
   public final void testRequiresListPermission() throws Exception
   {
      checkRequiresPermission();
   }

   @Override
   protected Request createRequest()
   {
      return new ExistsRequest(generateSliceNames(10, 1).get(0));
   }

   @Test
   public final void testSliceExists() throws Exception
   {
      ClientSession session = createClientSession();
      authenticateSession(session);
      addSliceStore(session);
      addListPermission(session);

      SliceStore sliceStore = getSliceStore(session);

      List<SliceName> names = generateSliceNames(10, 1);

      List<DataSlice> slices = createDataSlices(names);

      sliceStore.startSession();
      writeSlices(sliceStore, slices);

      Response response = this.handler.service(createRequest(), session);

      sliceStore.endSession();

      assertFalse(response.getExceptionFlag());

      assertTrue(response instanceof ExistsResponse);
      ExistsResponse existsResponse = (ExistsResponse) response;

      assertTrue(existsResponse.doesExist());
   }

   @Test
   public final void testSliceDoesNotExist() throws Exception
   {
      ClientSession session = createClientSession();
      authenticateSession(session);
      addSliceStore(session);
      addListPermission(session);

      SliceStore sliceStore = getSliceStore(session);

      sliceStore.startSession();

      Response response = this.handler.service(createRequest(), session);

      sliceStore.endSession();

      assertFalse(response.getExceptionFlag());

      assertTrue(response instanceof ExistsResponse);
      ExistsResponse existsResponse = (ExistsResponse) response;

      assertFalse(existsResponse.doesExist());
   }

}
