package org.cleversafe.storage.ss.handlers.sessions;

import static org.junit.Assert.assertEquals;

import org.cleversafe.layer.protocol.EndSessionRequest;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.exceptions.ProtocolLayerException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreExistsException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreIOException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreLayerException;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.exceptions.IllegalSessionStateException;
import org.cleversafe.server.exceptions.ServerException;
import org.cleversafe.storage.ss.handlers.HandlerTestBase;
import org.cleversafe.vault.exceptions.VaultException;
import org.junit.Test;

public class EndSessionHandlerTest extends HandlerTestBase
{
   // Creates a request to be used by the handler
   @Override
   protected Request createRequest()
   {
      return new EndSessionRequest();
   }

   @Test(expected = IllegalSessionStateException.class)
   public final void testRequiresSliceStore() throws ProtocolLayerException,
         SliceStoreLayerException, ServerException, VaultException
   {
      checkRequiresSliceStore();
   }
   
   @Test
   public final void testService() throws SliceStoreExistsException, SliceStoreIOException, Exception
   {
      ClientSession session = this.createClientSession();
      session = this.authenticateSession(session);
      session = this.addSliceStore(session);

      // Begin session on slice store
      getSliceStore(session).startSession();
      
      // Ensure the Slice Store is operational
      assertEquals(true, this.getSliceStore(session).isOperational());
      
      // End the Session
      Response response = this.handler.service(createRequest(), session);
      
      // Check that no exception was returned
      assertEquals(false, response.getExceptionFlag());
      
      // Ensure the Slice Store was removed
      assertEquals(null, this.getSliceStore(session));
   }

}
