package org.cleversafe.storage.ss.handlers.sessions;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.UUID;

import org.cleversafe.layer.protocol.BeginSessionRequest;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.exceptions.IllegalSessionStateException;
import org.cleversafe.storage.ss.handlers.HandlerTestBase;
import org.junit.Test;

public class BeginSessionHandlerTest extends HandlerTestBase
{

   // Creates a request to be used by the handler
   @Override
   protected Request createRequest()
   {
      return new BeginSessionRequest();
   }

   @Test(expected = IllegalSessionStateException.class)
   public final void testRequiresNoSliceStore() throws Exception
   {
      UUID vaultId = UUID.randomUUID();
      
      ClientSession session = this.createClientSession();
      session = this.authenticateSession(session);
      session = this.bindVault(session, vaultId);
      session = this.addSliceStore(session, vaultId);
      
      this.handler.service(createRequest(), session);
   }

   @Test
   public final void testService() throws Exception
   {
      // Create SliceStore in a separate session object
      UUID vaultIdentifier = UUID.randomUUID();
      this.addSliceStore(this.createClientSession(), vaultIdentifier);
      
      // Setup session
      ClientSession session = this.createClientSession();
      session = this.authenticateSession(session);
      session = this.bindVault(session, vaultIdentifier);
      
      // Make sure the Slice store is not existent prior to calling handler
      assertEquals(null, this.getSliceStore(session));
      
      // Start the Slice Store
      Response response = this.handler.service(createRequest(), session);

      assertEquals(false, response.getExceptionFlag());

      // Make sure SliceStore was created ans is now operational
      assertNotNull(this.getSliceStore(session));
      assertEquals(true, this.getSliceStore(session).isOperational());

      // End session on slice store
      getSliceStore(session).endSession();      
   }

}
