//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: dhendrickson
//
// Date: Nov 11, 2007
//---------------------

package org.cleversafe.storage.ss.configuration;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.util.Properties;

import org.cleversafe.authentication.AuthenticationFacilitatorConfiguration;
import org.cleversafe.layer.communication.Acceptor;
import org.cleversafe.layer.communication.network.mina.MinaAcceptor;
import org.cleversafe.layer.slicestore.SliceStoreManager;
import org.cleversafe.layer.slicestore.block.BlockFileSliceStoreManager;
import org.cleversafe.serialization.ProtocolMessageFactory;
import org.cleversafe.serialization.raw.RawGridProtocolMessageFactory;
import org.cleversafe.server.exceptions.ServerConfigurationLoadException;
import org.cleversafe.storage.ss.SliceServerConfiguration;
import org.cleversafe.test.BaseTest;
import org.cleversafe.test.TestException;
import org.junit.Test;

public class XMLConfigurationLoaderTest extends BaseTest
{
   @Test
   public void testLoadWithoutProperties() throws TestException, ServerConfigurationLoadException
   {
      File dir = getInputDirectory();
    
      System.setProperty("org.cleversafe.xml.configuration", dir + "/bindings-config.xml");
      
      XMLConfigurationLoader loader = new XMLConfigurationLoader(dir + "/server-config-no-properties.xml");
      SliceServerConfiguration configuration = loader.getConfiguration(null);
      
      assertTrue(configuration != null);
      
      Acceptor acceptor = configuration.getAcceptor();
      assertTrue(acceptor != null);
      assertTrue(acceptor instanceof MinaAcceptor);
      assertEquals(5001, ((MinaAcceptor)acceptor).getPort());
      assertEquals("0.0.0.0", ((MinaAcceptor)acceptor).getHost());
      assertEquals(false, ((MinaAcceptor)acceptor).getEnableSSL());
      assertEquals(false, ((MinaAcceptor)acceptor).getEnableLogging());
      
      ProtocolMessageFactory protocolMessageFactory = configuration.getProtocolMessageFactory();
      assertTrue(protocolMessageFactory != null);
      assertTrue(protocolMessageFactory instanceof RawGridProtocolMessageFactory);
      
      AuthenticationFacilitatorConfiguration jaasConfiguration = configuration.getAuthenticationFacilitatorConfiguration();
      assertTrue(jaasConfiguration != null);
      assertEquals("always-authenticate", jaasConfiguration.getDefaultMethod());
      
      String[] vaultTypes = configuration.getVaultTypes();
      assertEquals(2, vaultTypes.length);
 
      assertTrue(vaultTypes[0].equals("block"));
      SliceStoreManager manager1 = configuration.getDefaultSliceStoreManager(vaultTypes[0]);
      assertTrue(manager1 != null);
      assertTrue(manager1 instanceof BlockFileSliceStoreManager);
      
      assertTrue(vaultTypes[1].equals("file"));
      SliceStoreManager manager2 = configuration.getDefaultSliceStoreManager(vaultTypes[1]);
      assertTrue(manager2 != null);
      assertTrue(manager2 instanceof BlockFileSliceStoreManager);
      
      assertTrue(manager1 != manager2);
   }
   
   @Test
   public void testLoadWithProperties() throws TestException, ServerConfigurationLoadException
   {
      File dir = getInputDirectory();
    
      System.setProperty("org.cleversafe.xml.configuration", dir + "/bindings-config.xml");
      
      XMLConfigurationLoader loader = new XMLConfigurationLoader(dir + "/server-config-properties.xml");
      
      for(int a=5001; a<=5016; a++)
      {
         Properties properties = new Properties();
         properties.setProperty("ACCEPTOR.PORT", Integer.toString(a));
         SliceServerConfiguration configuration = loader.getConfiguration(properties);
         
         assertTrue(configuration != null);
         
         Acceptor acceptor = configuration.getAcceptor();
         assertTrue(acceptor != null);
         assertTrue(acceptor instanceof MinaAcceptor);
         assertEquals(a, ((MinaAcceptor)acceptor).getPort());
         assertEquals("0.0.0.0", ((MinaAcceptor)acceptor).getHost());
         assertEquals(false, ((MinaAcceptor)acceptor).getEnableSSL());
         assertEquals(false, ((MinaAcceptor)acceptor).getEnableLogging());
         
         ProtocolMessageFactory protocolMessageFactory = configuration.getProtocolMessageFactory();
         assertTrue(protocolMessageFactory != null);
         assertTrue(protocolMessageFactory instanceof RawGridProtocolMessageFactory);
         
         AuthenticationFacilitatorConfiguration authConfiguration = configuration.getAuthenticationFacilitatorConfiguration();
         assertTrue(authConfiguration != null);
         assertEquals("always-authenticate", authConfiguration.getDefaultMethod());
         
         String[] vaultTypes = configuration.getVaultTypes();
         assertEquals(2, vaultTypes.length);
    
         assertTrue(vaultTypes[0].equals("block"));
         SliceStoreManager manager1 = configuration.getDefaultSliceStoreManager(vaultTypes[0]);
         assertTrue(manager1 != null);
         assertTrue(manager1 instanceof BlockFileSliceStoreManager);
         
         assertTrue(vaultTypes[1].equals("file"));
         SliceStoreManager manager2 = configuration.getDefaultSliceStoreManager(vaultTypes[1]);
         assertTrue(manager2 != null);
         assertTrue(manager2 instanceof BlockFileSliceStoreManager);
         
         assertTrue(manager1 != manager2);
      }
   }
}


