//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: dhendrickson
//
// Date: Nov 19, 2007
//---------------------

package org.cleversafe.storage.ss;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.Arrays;
import java.util.HashMap;

import org.cleversafe.authentication.AuthenticationFacilitatorConfiguration;
import org.cleversafe.authentication.JAASConfiguration;
import org.cleversafe.authentication.loginmodules.AlwaysAuthenticateLoginModule;
import org.cleversafe.layer.communication.network.mina.MinaAcceptor;
import org.cleversafe.layer.communication.network.mina.MinaConnector;
import org.cleversafe.layer.communication.policy.SimpleConnectorManager;
import org.cleversafe.layer.protocol.NoopRequest;
import org.cleversafe.layer.protocol.NoopResponse;
import org.cleversafe.serialization.ProtocolMessageFactory;
import org.cleversafe.serialization.raw.RawGridProtocolMessageFactory;
import org.cleversafe.test.BaseTest;
import org.junit.Test;

public class SliceServerDaemonTest extends BaseTest
{
   private static class ServerRunnable implements Runnable
   {
      private SliceServerDaemon daemon;
      
      public ServerRunnable(SliceServerDaemon daemon)
      {
         this.daemon = daemon;
      }
      
      public void run()
      {
         try
         {
            this.daemon.run();
         }
         catch(Exception ex)
         {
            fail();
         }
      }
   }
   
   @Test
   public void testRunAndShutdown() throws Exception
   {
      // Setup daemon
      SliceServerConfiguration config = new SliceServerConfiguration();
      
      MinaAcceptor acceptor = new MinaAcceptor();
      acceptor.setHost("127.0.0.1");
      acceptor.setPort(5001);
      config.setAcceptor(acceptor);
      
      ProtocolMessageFactory protocolMessageFactory = new RawGridProtocolMessageFactory();
      config.setProtocolMessageFactory(protocolMessageFactory);
      
      AuthenticationFacilitatorConfiguration authConfiguration = new JAASConfiguration();
      authConfiguration.addAuthenticationMethod("always-authenticate",
                                                AlwaysAuthenticateLoginModule.class,
                                                AuthenticationFacilitatorConfiguration.ModuleControlFlag.REQUIRED,
                                                new HashMap<String,String>());
      config.setAuthenticationFacilitatorConfiguration(authConfiguration);
      
      SliceServerDaemon daemon = new SliceServerDaemon(config);
      
      // Start daemon
      Thread thread = new Thread(new ServerRunnable(daemon));
      thread.start();
      
      assertTrue("Daemon thread died prematurely", thread.isAlive());
      
      // Send Noop request 
      MinaConnector connector = new MinaConnector(acceptor.getHost(),
                                                  acceptor.getPort(), 
                                                  new SimpleConnectorManager(), 
                                                  acceptor.getProtocolMessageFactory());
      connector.connect();
      byte[] bytes = {3,1,6,8}; 
      NoopRequest request = new NoopRequest();
      request.setPayload(bytes);
      NoopResponse response = (NoopResponse)connector.exchange(request);
      connector.disconnect();
      assertTrue("Invalid response from daemon", Arrays.equals(request.getPayload(), response.getPayload()));
      
      // Attempt shutdown
      daemon.shutdown();
      thread.join(5000);

      // Confirm that thread was shutdown 
      assertTrue(!thread.isAlive());
   }
}


