package org.cleversafe.storage.ss.handlers.transactions;

// TODO: clenup unused imports.
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

import org.apache.log4j.BasicConfigurator;
import org.cleversafe.layer.grid.DataSlice;
import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.layer.protocol.BeginTransactionRequest;
import org.cleversafe.layer.protocol.BeginTransactionResponse;
import org.cleversafe.layer.protocol.MultipleWriteRequest;
import org.cleversafe.layer.protocol.MultipleWriteResponse;
import org.cleversafe.layer.protocol.RollbackTransactionRequest;
import org.cleversafe.layer.protocol.RollbackTransactionResponse;
import org.cleversafe.server.ClientSession;
import org.cleversafe.storage.ss.SliceServerApplication;
import org.cleversafe.storage.ss.handlers.SliceStorePerformanceBase;
import org.cleversafe.storage.ss.handlers.slices.PerformanceResults;
import org.cleversafe.util.BoundedThreadPoolExecutor;
import org.junit.BeforeClass;
import org.junit.Test;


public class RollbackTransactionHandlerPerformanceTest extends SliceStorePerformanceBase
{


	// How long test should be run. This is mutually exclusive with testIterations
	// Only one of them is used.
	private static int testDuration;
	// I/O Request Size in KB
	private static int requestSize;
	// Number of concurrent requests
	private static int numConcurrentRequests;

	// how many operations to be performed. This is mutually exclusive with testDuration.
	// Only one of them is used.
	private static int testIterations;
	
	private static UUID accountUUID;
	private SliceServerApplication sliceServer = null;

	private static ClientSession sessions[];

	public  byte[] data;
	
	@BeforeClass
	public static void initializeTests()
	{
		

		// Only one of testIterations or testDuration is used.
		testIterations = Integer.getInteger("test.operations", 1000); //
		testDuration = Integer.getInteger("test.duration", 1); // 1 minutes
		numConcurrentRequests = Integer.getInteger("test.concurrency", 7); //
		requestSize = Integer.getInteger("test.requestsize", 4); // 4K

		// Setup basic logging
		BasicConfigurator.configure();
		// Create data once and write the same stuff over and over again.

	}
	
		
	@Test
	public void commitTransactionHandlerPerformance_n()
	{
	
		data = new byte[requestSize * 1024];
		randomizeBuffer(data);
		
		class WorkItem implements Runnable
		{
			int sessionIdx;
			public WorkItem(int sess)
			{
				sessionIdx = sess;
			}
			public void run()
			{
				RollbackTransactionHandlerPerformanceTest test = RollbackTransactionHandlerPerformanceTest.this;

				try {
					// Commit the Transaction, use sessionIdx as Txn id.
					RollbackTransactionResponse rollbackTransactionResponse = (RollbackTransactionResponse)
						test.sliceServer
							.service(new RollbackTransactionRequest(sessionIdx),  sessions[sessionIdx]);
					
					// Ensure no exception flag was set
					assertTrue("An exception was thrown by the SliceServer",
							rollbackTransactionResponse.getExceptionFlag() == false);
				} catch (ClassCastException ex) {
					fail("SliceServer returned an inproper Response type");
				}
	         }
	      }
	
		// create an array of sessions, and a transaction in each session.
		sessions = new ClientSession[testIterations];
		// create an array of sessions.
		int operations;
		for (operations = 1; operations < testIterations; operations++) {
			// create a session
			try
			{
				sessions[operations] = createSession();
			} catch (Exception ex) {
				ex.printStackTrace();
				fail("Error creating session " + operations);
			}
			// create a transaction.
			try {
				// Create Transaction, use sessionIdx as Txn id.
				BeginTransactionResponse beginTransactionResponse = (BeginTransactionResponse)
					this.sliceServer.service(new BeginTransactionRequest(operations),  sessions[operations]);
				// Ensure no exception flag was set
				assertTrue("An exception was thrown by the SliceServer",
						beginTransactionResponse.getExceptionFlag() == false);
			} catch (ClassCastException ex) {
				fail("SliceServer returned an inproper Response type");
			}
			// write some data.
			try {
				// Create Request
				 
			   MultipleWriteResponse response = (MultipleWriteResponse) this.sliceServer
				.service(new MultipleWriteRequest( new DataSlice(new SliceName(Integer.toString(operations), 0), operations, data)), sessions[operations]);
				
				// Ensure no exception flag was set
				assertTrue("An exception was thrown by the SliceServer",
						response.getExceptionFlag() == false);
        	 } catch (ClassCastException ex) {
        		 fail("SliceServer returned an inproper Response type");
        	 }
		}
		
		ExecutorService executor = new BoundedThreadPoolExecutor("Commit Transaction Handler Test", numConcurrentRequests);
	
		// Start Operations.
		long beginTest, endTest;
		beginTest = System.currentTimeMillis();
		
		for (operations = 1; operations < testIterations; operations++) {

			executor.execute( new WorkItem(operations) );
		}
		      
		executor.shutdown();
		System.out.println("Waiting for threads to stop.");
		boolean finished = false;
		do
		{
			try
			{
				finished = executor.awaitTermination( 10, TimeUnit.SECONDS );
			} catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		} while ( !finished );
		
		endTest = System.currentTimeMillis();
//		System.out.println(testIterations + "|" + beginTest + "|" + endTest + "|" + numConcurrentRequests);
		PerformanceResults results =  new PerformanceResults("CommitTransaction", testIterations, 0, beginTest, endTest, numConcurrentRequests);
		results.print(true);

	}
	
}


