package org.cleversafe.storage.ss.handlers.slices;


import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

import org.cleversafe.layer.protocol.BeginTransactionRequest;
import org.cleversafe.layer.protocol.BeginTransactionResponse;
import org.cleversafe.layer.protocol.CommitTransactionRequest;
import org.cleversafe.layer.protocol.CommitTransactionResponse;
import org.cleversafe.layer.protocol.ErrorResponse;
import org.cleversafe.layer.protocol.GridProtocolResponse;
import org.cleversafe.layer.protocol.MultipleWriteRequest;
import org.cleversafe.layer.protocol.MultipleWriteResponse;
import org.cleversafe.storage.ss.handlers.SliceStorePerformanceBase;
import org.cleversafe.util.BoundedThreadPoolExecutor;
import org.junit.Test;

public class WriteHandlerPerformanceTest extends SliceStorePerformanceBase
{


		
	@Test
	public void writeHandlerPerformance()
	{
	
		
		class WorkItem implements Runnable
		{
			int sliceNum;
			public WorkItem(int slice)
			{
				sliceNum = slice;
			}
			public void run()
			{
				WriteHandlerPerformanceTest test = WriteHandlerPerformanceTest.this;;
				try {
					// Create Request
					 
					GridProtocolResponse response = (GridProtocolResponse)test.sliceServer
					.service( new MultipleWriteRequest(dataSlices[sliceNum]), session);
					
					if (response instanceof ErrorResponse) 
					{
						System.out.println(response.getException());
					} else {
					   MultipleWriteResponse ws = (MultipleWriteResponse)response;
					}
					// Ensure no exception flag was set
					assertTrue("An exception was thrown by the SliceServer",
							response.getExceptionFlag() == false);
	        	 } catch (ClassCastException ex) {
	        		 
	        		 ex.printStackTrace();
	        		 fail("SliceServer returned an inproper Response type");
	        	 }
	         }
	      }
	
		ExecutorService executor = new BoundedThreadPoolExecutor("Write Handler Test", numConcurrentRequests);
		try {
			// Create a session with a valid SliceStore
			session = createSession();
		} catch (Exception ex) {
			ex.printStackTrace();
			fail("Unable to start an operational slice store");
		}
		long beginTest, endTest;
		beginTest = System.currentTimeMillis();
		
		try {
			// Create Transaction
			BeginTransactionResponse beginTransactionResponse = (BeginTransactionResponse) this.sliceServer
					.service(new BeginTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			if (beginTransactionResponse.getExceptionFlag()) {
				beginTransactionResponse.getException().printStackTrace();
			}
			assertTrue("An exception was thrown by the SliceServer",
					beginTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}
		
		// Start Operations.
		int operations;
		
		for (operations = 1; operations < testIterations; operations++) {
			// execute in an available thread.
			executor.execute( new WorkItem(operations) );
		}
		      
		executor.shutdown();
		System.out.println("Waiting for threads to stop.");
		boolean finished = false;
		do
		{
			try
			{
				finished = executor.awaitTermination( 10, TimeUnit.SECONDS );
			} catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		} while ( !finished );
	
		// Commit Transaction.
		
		try {
			// Commit Transaction
			CommitTransactionResponse commitTransactionResponse = (CommitTransactionResponse) this.sliceServer
					.service(new CommitTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer",
					commitTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}
		endTest = System.currentTimeMillis();
	
		PerformanceResults results =  new PerformanceResults("WriteHandler", testIterations, requestSize, beginTest, endTest);
		results.print(true);

	}
}
