package org.cleversafe.storage.ss.handlers.slices;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

import org.cleversafe.layer.grid.DataSlice;
import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.layer.protocol.BeginTransactionRequest;
import org.cleversafe.layer.protocol.BeginTransactionResponse;
import org.cleversafe.layer.protocol.CommitTransactionRequest;
import org.cleversafe.layer.protocol.CommitTransactionResponse;
import org.cleversafe.layer.protocol.ListBeginRequest;
import org.cleversafe.layer.protocol.ListBeginResponse;
import org.cleversafe.layer.protocol.ListContinueRequest;
import org.cleversafe.layer.protocol.ListContinueResponse;
import org.cleversafe.layer.protocol.ListInProgressRequest;
import org.cleversafe.layer.protocol.ListInProgressResponse;
import org.cleversafe.layer.protocol.MultipleWriteRequest;
import org.cleversafe.layer.protocol.MultipleWriteResponse;
import org.cleversafe.server.ClientSession;
import org.cleversafe.storage.ss.handlers.SliceStorePerformanceBase;
import org.cleversafe.util.BoundedThreadPoolExecutor;
import org.junit.Test;

public class SliceListingPerformanceTest extends SliceStorePerformanceBase
{

	/*
	 * Writes number of slices equal to the number of testIterations.
	 * 
	 */
	private ClientSession writeSlices()
	{
		
		session = null;
		// Create a session
		if (session == null) {
			try {
				// Create a session with a valid SliceStore
				session = createSession();
			} catch (Exception ex) {
				ex.printStackTrace();
				fail("Unable to start an operational slice store");
			}
		}
		
		// Create a transaction
		try {
			// Create Transaction
			BeginTransactionResponse beginTransactionResponse = (BeginTransactionResponse) this.sliceServer
					.service(new BeginTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer",
					beginTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}
		int i;
		for (i=1; i< testIterations; i++) {
			writeSlice(sliceStrings[i], data);
		}
		
		// Commit the transaction.
		try {
			// Commit Transaction
			CommitTransactionResponse commitTransactionResponse = (CommitTransactionResponse) this.sliceServer
					.service(new CommitTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer",
					commitTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}

		return session;
	}
	
	
	@Test
	public void sliceListingPerformance_n()
	{
	
		// Create a session in which a slices have been written. No need to do in threads.
		session = writeSlices();
	
		class WorkItem implements Runnable
		{

			int sliceNum;
			public WorkItem(int slice)
			{
				sliceNum = slice;
			}
			public void run()
			{
				SliceListingPerformanceTest test = SliceListingPerformanceTest.this;
				ListInProgressResponse response=null;
				try {
					// Create Request and ask server to service it.
					// TODO: check ListInProgress is true.
					response = (ListInProgressResponse) test.sliceServer
					.service(new ListInProgressRequest(), session);
				
					if (response.getExceptionFlag())
					{
						response.getException().printStackTrace();
						fail("Exception in responce.");
					}
				} catch (ClassCastException ex) {
					ex.printStackTrace();
					fail("SliceServer returned an improper Response type");
				}
					 
				while (response.listInProgress())
				{
					try {
						ListContinueResponse response1 = (ListContinueResponse) test.sliceServer
						.service(new ListContinueRequest(), session);
				
						if (response1.getExceptionFlag())
						{
							response1.getException().printStackTrace();
							fail("Exception in responce.");
						}
					} catch (ClassCastException ex) {
						ex.printStackTrace();
						fail("SliceServer returned an improper Response type");
					}
					// check listInProgress again.
					try {
						// Create Request and ask server to service it.
						// TODO: check ListInProgress is true.
						response = (ListInProgressResponse) test.sliceServer
						.service(new ListInProgressRequest(), session);
					
						if (response.getExceptionFlag())
						{
							response.getException().printStackTrace();
							fail("Exception in responce.");
						}
					} catch (ClassCastException ex) {
						ex.printStackTrace();
						fail("SliceServer returned an improper Response type");
					}
				}
			}
		}
		
		ExecutorService executor = new BoundedThreadPoolExecutor("ListContinue handler Test", numConcurrentRequests);

		// Create a transaction
		try {
			// Create Transaction
			BeginTransactionResponse beginTransactionResponse = (BeginTransactionResponse) this.sliceServer
					.service(new BeginTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer",
					beginTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}
		
		// Start Operations.
		int operations;
		long beginTest, endTest;
		beginTest = System.currentTimeMillis();
		System.out.println("Begin test.");
		
		beginTest = System.currentTimeMillis();
		System.out.println("Begin test.");

		// Needs a ListBegin first.
		try {
			// Create Request and ask server to service it.
			ListBeginResponse response = (ListBeginResponse) sliceServer
			.service(new ListBeginRequest(), session);
		
			if (response.getExceptionFlag())
			{
				response.getException().printStackTrace();
				fail("Exception in responce.");
			}
		} catch (ClassCastException ex) {
			ex.printStackTrace();
			fail("SliceServer returned an improper Response type");
		}

		for (operations = 1; operations < testIterations; operations++) {
			// execute in an available thread.
			// executor.execute( new WorkItem(operations) );
			( new WorkItem(operations)).run();
		}
		      
		executor.shutdown();
		System.out.println("Waiting for threads to stop.");
		boolean finished = false;
		do {
			try {
				finished = executor.awaitTermination( 10, TimeUnit.SECONDS );
			} catch (InterruptedException e){
				e.printStackTrace();
			}
		} while ( !finished );

		try {
			// Create Transaction
			CommitTransactionResponse commitTransactionResponse = (CommitTransactionResponse) this.sliceServer
					.service(new CommitTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			if (commitTransactionResponse.getExceptionFlag()) {
				commitTransactionResponse.getException().printStackTrace();
			}
			assertTrue("An exception was thrown by the SliceServer",
					commitTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}
		endTest = System.currentTimeMillis();
		

		// we use testIterations as number of slices and also perform testIteration times
		// the listing operations. Hence the total  number of slices listed are testIteration*testIteration
		PerformanceResults results =  new PerformanceResults("ListSlices", testIterations, requestSize, beginTest, endTest, numConcurrentRequests);
		results.print(true);
		
	}
	
	/**
	 * Sends an Write request to the server and verifies that the slice is
	 * stored
	 * 
	 */
	private void writeSlice(String sliceName, byte[] data) {

		// Create a begin session request
	   MultipleWriteRequest request = new MultipleWriteRequest(new DataSlice(new SliceName(
				sliceName, 0), txnID, data));

		try {
			// Process the request on our custom ClientSession object
		   MultipleWriteResponse response = (MultipleWriteResponse) this.sliceServer.service(
					request, session);

			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer", response
					.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}
	}
}
