package org.cleversafe.storage.ss.handlers.slices;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import org.cleversafe.layer.protocol.BeginTransactionRequest;
import org.cleversafe.layer.protocol.BeginTransactionResponse;
import org.cleversafe.layer.protocol.CommitTransactionRequest;
import org.cleversafe.layer.protocol.CommitTransactionResponse;
import org.cleversafe.layer.protocol.MultipleRemoveRequest;
import org.cleversafe.layer.protocol.MultipleRemoveResponse;
import org.cleversafe.layer.protocol.MultipleWriteRequest;
import org.cleversafe.layer.protocol.MultipleWriteResponse;
import org.cleversafe.server.ClientSession;
import org.cleversafe.storage.ss.handlers.SliceStorePerformanceBase;
import org.junit.Test;

public class RemoveHandlerPerformanceTest extends SliceStorePerformanceBase
{


	@Test
	public void removeHandlerPerformance()
	{
		// Create a session in which a slices have been written.
		session = writeSlices();

		long beginTest, endTest, duration;
		beginTest = System.currentTimeMillis();

		// Start a new transaction for removing.
		try {
			// Create Transaction
			BeginTransactionResponse beginTransactionResponse = (BeginTransactionResponse) this.sliceServer
					.service(new BeginTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer",
					beginTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}
		
		int sliceNum;

		for (sliceNum = 1; sliceNum < testIterations; sliceNum++) {
			try {
				// Create Request
			   MultipleRemoveResponse removeResponse = (MultipleRemoveResponse) this.sliceServer
				.service(new MultipleRemoveRequest(sliceNames[sliceNum]), session);
				
				// Ensure no exception flag was set
				assertTrue("An exception was thrown by the SliceServer",
						removeResponse.getExceptionFlag() == false);
			} catch (ClassCastException ex) {
				fail("SliceServer returned an inproper Response type");
			}
		}
	
		try {
			// Commit Transaction
			CommitTransactionResponse commitTransactionResponse = (CommitTransactionResponse) this.sliceServer
					.service(new CommitTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer",
					commitTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}

		endTest = System.currentTimeMillis();
			
		duration = endTest - beginTest;
		System.out.println("Operations=" + testIterations + " : Duration(ms)=" + duration +
							" : Ops/s=" + (testIterations * 1000.0)/ duration + " : Rate=(MB/s)" 
							+ (testIterations * 1000.0 * requestSize)/ (1024 * duration));
	}

	/*
	 * Writes number of slices equal to the number of testIterations.
	 * 
	 */
	private ClientSession writeSlices()
	{
		
		session = null;

		if (session == null) {
			try {
				// Create a session with a valid SliceStore
				session = createSession();
			} catch (Exception ex) {
				ex.printStackTrace();
				fail("Unable to start an operational slice store");
			}
		}
		try {
			// Create Transaction
			BeginTransactionResponse beginTransactionResponse = (BeginTransactionResponse) this.sliceServer
					.service(new BeginTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer",
					beginTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}
	
		int i;
		for (i=1; i< testIterations; i++) {
			writeSlice(i, data);
		}
		

		try {
			// Commit Transaction
			CommitTransactionResponse commitTransactionResponse = (CommitTransactionResponse) this.sliceServer
					.service(new CommitTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer",
					commitTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}

		return session;
	}
	
	/**
	 * Sends an Write request to the server and verifies that the slice is
	 * stored
	 * 
	 */
	private void writeSlice(int slice, byte[] data) {

		// Create a begin session request
	   MultipleWriteRequest request = new MultipleWriteRequest(dataSlices[slice]);

		try {
			// Process the request on our custom ClientSession object
		   MultipleWriteResponse response = (MultipleWriteResponse) this.sliceServer.service(
					request, session);

			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer", response
					.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}
	}
}
