package org.cleversafe.storage.ss.handlers.slices;

public class PerformanceResults {

	// TODO: Make them private.
	public long numOperations;
	public double rate; // in MB/s
	public int requestSize; // in KBs
	public int threadConcurrancy; 
	public long testDuration; // in ms
	public long duration; // ms
	public String opName;
	
	public int numRequestsInOper = 0;
	
	public PerformanceResults(String name, long ops, int size, long startTime, long endTime)
	{
		opName = name;
		threadConcurrancy = 1;
		numOperations = ops;
		requestSize = size;
		duration = endTime-startTime;
	}
	
	public PerformanceResults(String name, long ops, int size, long startTime, long endTime, int threads)
	{
		opName = name;
		threadConcurrancy = threads;
		numOperations = ops;
		requestSize = size;
		duration = endTime-startTime;
	}
	
	public void print(boolean heading)
	{
		if (heading)
		{
			if (numRequestsInOper > 0) {
				System.out.println("OPERATION    NumRequestInOper    THREADs    REQUST SIZE   OPS/s      MB/s");
			} else {
				System.out.println("OPERATION           THREADs    REQUST SIZE   OPS/s      MB/s");
			}
		}
		if (numRequestsInOper > 0) {
			System.out.println(String.format("%-17s    %3d      %6d   %10d       %.3f   %.3f", 
					opName, numRequestsInOper, threadConcurrancy, requestSize, (numOperations * 1000.0)/ duration,  (numOperations* 1000.0 * requestSize)/ (1024 * duration)));
		} else {
			System.out.println(String.format("%-17s  %6d   %10d       %.3f   %.3f", 
					opName, threadConcurrancy, requestSize, (numOperations * 1000.0)/ duration,  (numOperations* 1000.0 * requestSize)/ (1024 * duration)));

		}
	}
	
	public void setNumRequestsInOper(int num)
	{
		numRequestsInOper = num;
	}
}
