package org.cleversafe.storage.ss.handlers.slices;


import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;


import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;


import org.cleversafe.layer.grid.DataSlice;
import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.layer.protocol.BeginTransactionRequest;
import org.cleversafe.layer.protocol.BeginTransactionResponse;
import org.cleversafe.layer.protocol.CommitTransactionRequest;
import org.cleversafe.layer.protocol.CommitTransactionResponse;
import org.cleversafe.layer.protocol.MultipleWriteRequest;
import org.cleversafe.layer.protocol.MultipleWriteResponse;

import java.util.HashMap;

import org.cleversafe.storage.ss.handlers.SliceStorePerformanceBase;
import org.cleversafe.util.BoundedThreadPoolExecutor;
import org.junit.Test;


public class MultipleWriteHandlerPerformanceTest extends SliceStorePerformanceBase
{
	public static HashMap<Integer, DataSlice[]> multiDataSlices = null;

	@Test
	public void multipleWriteHandlerPerformance()
	{
	
		class WorkItem implements Runnable
		{
			DataSlice dataSlices[];
			int firstSliceId;
			public WorkItem(int id)
			{
				firstSliceId = id;
				dataSlices = multiDataSlices.get(firstSliceId);
			}
			public void run()
			{
				MultipleWriteHandlerPerformanceTest test = MultipleWriteHandlerPerformanceTest.this;;
				try {
					// Create Request
					 
					MultipleWriteResponse response = (MultipleWriteResponse) test.sliceServer
					.service(new MultipleWriteRequest(dataSlices), session);
					
					if (response.getExceptionFlag()) 
					{
						response.getException().printStackTrace();
					}
					// Ensure no exception flag was set
					assertTrue("An exception was thrown by the SliceServer",
							response.getExceptionFlag() == false);
	        	 } catch (ClassCastException ex) {
	        		 ex.printStackTrace();
	        		 fail("SliceServer returned an inproper Response type");
	        	 }
	         }
	      }
		
		// create multiple data slices used for MultipleReadWrite operations.
		// the map multiDataSlice contains map of <firstslice> -> DataqSlices[] array of numRequestinOper size.
		multiDataSlices = new HashMap<Integer, DataSlice[]>();
		int operations;
		for (operations = 1; operations < testIterations; operations += numRequestsInOper)
		{
			DataSlice ds[] = new DataSlice[numRequestsInOper];
			for (int i=0; i < MultipleWriteHandlerPerformanceTest.numRequestsInOper; i++)
			{
				ds[i] =
					new DataSlice(
							new SliceName(Integer.toString(operations + i), 0), txnID, data);
			}
			multiDataSlices.put(operations, ds);
		}
	
		ExecutorService executor = new BoundedThreadPoolExecutor("Multi Write Handler", numConcurrentRequests);
		try {
			// Create a session with a valid SliceStore
			session = createSession();
		} catch (Exception ex) {
			ex.printStackTrace();
			fail("Unable to start an operational slice store");
		}
		
		// Start Operations.
		long beginTest, endTest;
		beginTest = System.currentTimeMillis();

		try {
			// Create Transaction
			BeginTransactionResponse beginTransactionResponse = (BeginTransactionResponse) this.sliceServer
					.service(new BeginTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer",
					beginTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}
		
		for (operations = 1; operations < testIterations; operations += numRequestsInOper) {
			// execute in an available thread.
			executor.execute( new WorkItem(operations) );
			//(new WorkItem(operations)).run();
		}
		      
		executor.shutdown();
		System.out.println("Waiting for threads to stop.");
		boolean finished = false;
		do
		{
			try
			{
				finished = executor.awaitTermination( 10, TimeUnit.SECONDS );
			} catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		} while ( !finished );
	
		// Commit Transaction.
		
		try {
			// Commit Transaction
			CommitTransactionResponse commitTransactionResponse = (CommitTransactionResponse) this.sliceServer
					.service(new CommitTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer",
					commitTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}
		endTest = System.currentTimeMillis();
				
		PerformanceResults results =  new PerformanceResults("MultiWriteHandler", testIterations, requestSize, beginTest, endTest);
		results.setNumRequestsInOper(numRequestsInOper);
		results.print(true);

	}
}
