package org.cleversafe.storage.ss;

import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.cleversafe.authentication.credentials.PasswordCredentials;
import org.cleversafe.layer.communication.network.mina.MinaConnector;
import org.cleversafe.layer.communication.policy.SmartConnectorManager;
import org.cleversafe.layer.grid.DataSlice;
import org.cleversafe.layer.grid.GridBaseTest;
import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.layer.slicestore.remote.RemoteSliceStore;
import org.cleversafe.layer.slicestore.remote.RemoteSliceStoreTransaction;
import org.cleversafe.serialization.raw.RawGridProtocolMessageFactory;
import org.cleversafe.storage.ss.configuration.XMLConfigurationLoader;
import org.cleversafe.vault.Vault;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SliceServerSessionTest extends GridBaseTest
{
   private final int sliceCount = 1000;
   private UUID vaultID;
   
   @Before
   public void before() throws Exception
   {
      XMLConfigurationLoader configLoader = new XMLConfigurationLoader(this.getInputDirectory().getAbsolutePath() + "/server-config.xml");
      SliceServerConfiguration configuration = configLoader.getConfiguration(null);
   
      SliceServerDaemon daemon = new SliceServerDaemon(configuration);
      Thread daemonThread = new Thread(daemon);
      daemonThread.start();
      
      Vault vault = this.createVault();
      this.vaultID = vault.getVaultIdentifier();
   }
   
   @After
   public void after() throws Exception
   {
      this.cleanupVault();
   }
   
	@Test
	public void test() throws Exception
	{
		MinaConnector connector = new MinaConnector("localhost", 5000, new SmartConnectorManager(), new RawGridProtocolMessageFactory());
	
		RemoteSliceStore sliceStore = new RemoteSliceStore();
		sliceStore.setConnection(connector);
		sliceStore.setCredentials(new PasswordCredentials("account_creator_1", "password"));
		sliceStore.setVaultIdentifier(this.vaultID);
		
		// Write first transaction
		RemoteSliceStoreTransaction transaction = new RemoteSliceStoreTransaction(1, sliceStore);
		List<DataSlice> slices = new ArrayList<DataSlice>();
		for(int a=1; a<=1000; a++)
		{
   		DataSlice slice = new DataSlice();
   		slice.setData(new byte[4096]);
   		slice.setSliceName(new SliceName(Integer.toString(a), a));
   		slice.setTransactionId(transaction.getID());
   		slices.add(slice);
		}
		sliceStore.beginTransaction(transaction);
      sliceStore.write(slices);

		// Write second transaction
		boolean isError = false;
   	try
      {
         transaction = new RemoteSliceStoreTransaction(2, sliceStore);
         for(int a=0; a<this.sliceCount; a++)
         {
            slices.get(a).setTransactionId(transaction.getID());
         }
         sliceStore.beginTransaction(transaction);
         sliceStore.write(slices);
      }
      catch (Exception ex)
      {
         isError = true;
      }
      assertTrue(isError);

      // End network session
      connector.disconnect();
      
      // Write third transaction
      isError = false;
      try
      {
         transaction = new RemoteSliceStoreTransaction(3, sliceStore);
         for(int a=0; a<this.sliceCount; a++)
         {
            slices.get(a).setTransactionId(transaction.getID());
         }
         sliceStore.beginTransaction(transaction);
         sliceStore.write(slices);
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
         isError = true;
      }
      assertTrue(!isError);
	}
}
