//Cleversafe open-source code header - Version 1.1 - December 1, 2006

//Cleversafe Dispersed Storage(TM) is software for secure, private and
//reliable storage of the world's data using information dispersal.

//Copyright (C) 2005-2007 Cleversafe, Inc.

//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.

//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.

//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
//USA.

//Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
//Chicago IL 60616
//email licensing@cleversafe.org

//END-OF-HEADER
//-----------------------
//@author: jquigley

//Date: Aug 20, 2007
//---------------------

package org.cleversafe.storage.ss;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.cleversafe.layer.communication.Connector;
import org.cleversafe.layer.communication.exceptions.CommunicationConnectionException;
import org.cleversafe.layer.communication.exceptions.CommunicationIOException;
import org.cleversafe.layer.communication.exceptions.CommunicationInterruptedException;
import org.cleversafe.layer.communication.exceptions.CommunicationResponseException;
import org.cleversafe.layer.communication.exceptions.CommunicationTransmissionException;
import org.cleversafe.layer.communication.exceptions.NotConnectedException;
import org.cleversafe.layer.protocol.NoopRequest;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.serialization.asn1.ASN1GridProtocolMessageFactory;
import org.cleversafe.server.exceptions.IllegalServerConfigurationContentException;
import org.cleversafe.server.exceptions.ServerConfigurationLoadException;
import org.cleversafe.storage.ss.SliceServerMemoryConnector;
import org.cleversafe.storage.ss.SliceServerConfiguration;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

//TODO: Describe class or interface
public class SliceServerConnectorTest
{
   private static Logger _logger = Logger.getLogger(SliceServerConnectorTest.class);

   ////////////////////////////////////////////////////////////////////////////
   // Configuration options.

   private static String _transmitFile = "conf/config.xml";
   private static int _transmitPayloadSize = 4096;

   private static final String JAAS_PROFILE_OPTION = "jaas_profile";

   private int _requestsToTransmit = 5000;
   private int _numConcurrentRequests = Runtime.getRuntime().availableProcessors() + 1;
   private int _numMultiConnect = 64;

   private static SliceServerConfiguration _config = null;

   ////////////////////////////////////////////////////////////////////////////
   // Internal members.

   private static byte[] _transmitBuf = new byte[_transmitPayloadSize];

   ////////////////////////////////////////////////////////////////////////////
   // SliceServer start and stop test wrappers

   @BeforeClass
   public static void initialize() throws IOException, IllegalServerConfigurationContentException,
         ServerConfigurationLoadException
   {
      BasicConfigurator.configure();
      String configFile =
            System.getProperty("org.cleversafe.storage.ss.xml.configuration");

      Map<String, Object> userSettings = new HashMap<String, Object>();
      userSettings.put(JAAS_PROFILE_OPTION, "always-authenticate");
      SliceServerConnectorTest._config = new SliceServerConfiguration();
      new FileInputStream(_transmitFile).read(_transmitBuf, 0, _transmitPayloadSize);
   }

   @AfterClass
   public static void shutdown()
   {
      _logger.info("SliceServer successfully stopped");
   }

   ////////////////////////////////////////////////////////////////////////////
   // Simple tests

   @Test
   public void serverPing() throws CommunicationIOException, CommunicationResponseException,
         CommunicationInterruptedException, NotConnectedException,
         CommunicationTransmissionException, CommunicationConnectionException
   {
      _logger.info("---------- [serverPing:begin] ----------");
      Connector conn =
            new SliceServerMemoryConnector(SliceServerConnectorTest._config,
                  new ASN1GridProtocolMessageFactory());
      conn.ensureConnected();

      Response response = conn.exchange(new NoopRequest());
      _logger.info("Response type is: " + response.getClass());

      conn.disconnect();
      _logger.info("---------- [serverPing:end] ----------");
   }
}
