//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: Zachary Mark
//
// Date: Sep 12, 2007
//---------------------

package org.cleversafe.server.handlers.version;

import static org.junit.Assert.fail;

import java.util.Iterator;

import org.apache.log4j.Logger;
import org.cleversafe.layer.communication.Connector;
import org.cleversafe.layer.communication.exceptions.CommunicationIOException;
import org.cleversafe.layer.communication.exceptions.CommunicationInterruptedException;
import org.cleversafe.layer.communication.exceptions.CommunicationResponseException;
import org.cleversafe.layer.communication.exceptions.CommunicationTransmissionException;
import org.cleversafe.layer.communication.exceptions.NotConnectedException;
import org.cleversafe.layer.protocol.ErrorResponse;
import org.cleversafe.layer.protocol.GetSupportedProtocolsRequest;
import org.cleversafe.layer.protocol.GetSupportedProtocolsResponse;
import org.cleversafe.layer.protocol.NoopRequest;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.server.ServerApplicationConnection;
import org.cleversafe.storage.ss.SliceServerApplication;
import org.cleversafe.storage.ss.SliceServerConfiguration;
import org.junit.Test;

public class ProtocolVersionIntegrationTest
{
   private static Logger _logger = Logger.getLogger(ProtocolVersionIntegrationTest.class);

   @Test
   public void testProtocolListRequest() throws CommunicationIOException, NotConnectedException,
         CommunicationInterruptedException, CommunicationResponseException,
         CommunicationTransmissionException
   {
      System.setProperty("org.cleversafe.storage.ss.xml.configuration",
            "test-data/org/cleversafe/server/handlers/version/slice-server.xml");

      // Create slice server
      SliceServerApplication sliceServer = null;
      try
      {
         sliceServer = new SliceServerApplication(new SliceServerConfiguration());
      }
      catch (Exception ex)
      {
         fail("Unable to construct sliceServer: " + ex.getMessage());
      }

      Connector conn = new ServerApplicationConnection(sliceServer);

      GetSupportedProtocolsRequest request = new GetSupportedProtocolsRequest();

      Response resp = conn.exchange(request);
      if(!(resp instanceof GetSupportedProtocolsResponse))
      {
         fail("Unexpected response type: " + resp.getException().getMessage());
      }
      
      
      GetSupportedProtocolsResponse response = (GetSupportedProtocolsResponse) resp;

      Iterator<Short> itr = response.getProtocolList().iterator();

      _logger.debug("Supported protocol list:");
      while (itr.hasNext())
      {
         String str = Short.toString(itr.next());
         _logger.debug(str);
      }
   }

   @Test
   public void testBadVersionRequest() throws CommunicationIOException, NotConnectedException,
         CommunicationInterruptedException, CommunicationResponseException,
         CommunicationTransmissionException
   {
      System.setProperty("org.cleversafe.storage.ss.xml.configuration",
            "test-data/org/cleversafe/server/handlers/version/slice-server.xml");
      
      // Create slice server
      SliceServerApplication sliceServer = null;
      try
      {
         SliceServerConfiguration config = new SliceServerConfiguration();
         sliceServer = new SliceServerApplication(config);
      }
      catch (Exception ex)
      {
         fail("Unable to construct sliceServer: " + ex.getMessage());
      }

      Connector conn = new ServerApplicationConnection(sliceServer);

      NoopRequest request = new NoopRequest();
      request.setProtocolVersion((short)-1);
      Response response = conn.exchange(request);

      if (!(response instanceof ErrorResponse))
      {
         fail("Unexpectedly did not receive BadProtocolVersionException");
      }
   }

}
