//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: mmotwani
//
// Date: Jul 18, 2007
//---------------------

package org.cleversafe.storage.ss;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import org.cleversafe.authentication.AuthenticationFacilitatorConfiguration;
import org.cleversafe.layer.communication.Acceptor;
import org.cleversafe.layer.slicestore.SliceStoreDescriptorManager;
import org.cleversafe.layer.slicestore.SliceStoreManager;
import org.cleversafe.serialization.ProtocolMessageFactory;

public final class SliceServerConfiguration
{
   private Acceptor acceptor;
   private ProtocolMessageFactory protocolMessageFactory;
   private AuthenticationFacilitatorConfiguration authConfiguration;
   private SliceStoreDescriptorManager sliceStoreDescriptorManager;
   private final Map<String, SliceStoreManager> vaultTypeSliceStoreManagerMap;

   public SliceServerConfiguration()
   {
      this.vaultTypeSliceStoreManagerMap = new TreeMap<String, SliceStoreManager>();
   }

   public Acceptor getAcceptor()
   {
      return this.acceptor;
   }

   public void setAcceptor(Acceptor acceptor)
   {
      this.acceptor = acceptor;
   }

   public ProtocolMessageFactory getProtocolMessageFactory()
   {
      return this.protocolMessageFactory;
   }

   public void setProtocolMessageFactory(ProtocolMessageFactory protocolMessageFactory)
   {
      this.protocolMessageFactory = protocolMessageFactory;
   }

   public AuthenticationFacilitatorConfiguration getAuthenticationFacilitatorConfiguration()
   {
      return this.authConfiguration;
   }

   public void setAuthenticationFacilitatorConfiguration(
         AuthenticationFacilitatorConfiguration authConfiguration)
   {
      this.authConfiguration = authConfiguration;
   }

   public SliceStoreDescriptorManager getSliceStoreDescriptorManager()
   {
      return this.sliceStoreDescriptorManager;
   }

   public void setSliceStoreDescriptorManager(
         SliceStoreDescriptorManager sliceStoreDescriptorManager)
   {
      this.sliceStoreDescriptorManager = sliceStoreDescriptorManager;
   }

   public SliceStoreManager getDefaultSliceStoreManager(String vaultType)
   {
      return this.vaultTypeSliceStoreManagerMap.get(vaultType);
   }

   public void addSliceStoreManager(String vaultType, SliceStoreManager sliceStoreManager)
   {
      this.vaultTypeSliceStoreManagerMap.put(vaultType, sliceStoreManager);
   }

   public String[] getVaultTypes()
   {
      Set<String> vaultSet = this.vaultTypeSliceStoreManagerMap.keySet();
      String[] vaultTypes = new String[vaultSet.size()];
      vaultSet.toArray(vaultTypes);

      return vaultTypes;
   }

   public Map<String, SliceStoreManager> getVaultSliceStoreManagerMap()
   {
      return Collections.unmodifiableMap(this.vaultTypeSliceStoreManagerMap);
   }
}
