//Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
//Cleversafe Dispersed Storage(TM) is software for secure, private and
//reliable storage of the world's data using information dispersal.
//
//Copyright (C) 2005-2007 Cleversafe, Inc.
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
//USA.
//
//Contact Information: 
// Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email: licensing@cleversafe.org
//
//END-OF-HEADER
//-----------------------
//@author: John Quigley <jquigley@cleversafe.com>
//@date: January 1, 2008
//---------------------

package org.jscsi.scsi.transport;

/**
 * Valid service responses as defined in SAM-3. Service responses are generated by the transport
 * layer and returned to the SCSI initiator through the {@link ConfirmationHandler}. These values
 * shall be serialized in a transport layer dependent manner.
 * <p>
 * Value descriptions are quoted from SAM-3 section 5.1. "Status argument" refers to the
 * {@link org.jscsi.scsi.tasks.Status} value returned by the SCSI target.
 */
public enum ServiceResponse
{

   /**
    * A logical unit response indicating that the task has ended. The
    * {@link org.jscsi.scsi.tasks.Status} argument shall have one of the values specified in 5.3
    * [SAM3] other than {@link org.jscsi.scsi.tasks.Status#INTERMEDIATE} or
    * {@link org.jscsi.scsi.tasks.Status#INTERMEDIATE_CONDITION_MET}.
    */
   TASK_COMPLETE,

   /**
    * Logical unit responses indicating that the task has not ended and that a linked command
    * has completed successfully. As specified in 5.3 [SAM3], the {@link org.jscsi.scsi.tasks.Status}
    * argument shall have a value of {@link org.jscsi.scsi.tasks.Status#INTERMEDIATE} or
    * {@link org.jscsi.scsi.tasks.Status#INTERMEDIATE_CONDITION_MET}.
    */
   LINKED_COMMAND_COMPLETE,

   /**
    * THe command has been ended due to a service delivery failure (see 3.1.112)[SAM3] or SCSI
    * target device malfunction. All output parameters are invalid.
    */
   SERVICE_DELIVERY_OR_TARGET_FAILURE;

}
