package org.jscsi.scsi.tasks.lu;

import org.apache.log4j.Logger;
import org.jscsi.scsi.tasks.Status;
import org.jscsi.scsi.protocol.Command;
import org.jscsi.scsi.protocol.inquiry.InquiryDataRegistry;
import org.jscsi.scsi.protocol.mode.ModePageRegistry;
import org.jscsi.scsi.protocol.sense.exceptions.SenseException;
import org.jscsi.scsi.transport.TargetTransportPort;

/**
 * A logical unit task which always returns a response with SCSI status GOOD.
 * Useful for providing stub implementations for unsupported/obsolete tasks
 * to get around testing tools that issue these commands.
 * 
 * @author Zachary Mark
 */
public class DummyLUTask extends LUTask 
{
	private static Logger _logger = Logger.getLogger(DummyLUTask.class);
	
	public DummyLUTask()
	{
		super("DummyLUTask");
	}

	public DummyLUTask(
			TargetTransportPort targetPort,
			Command command,
			ModePageRegistry modePageRegistry,
			InquiryDataRegistry inquiryDataRegistry)
	{
		super("DummyLUTask", targetPort, command, modePageRegistry, inquiryDataRegistry);
	}

	@Override
	protected void execute() throws InterruptedException
	{
		_logger.trace("Executing dummy logical unit task for command: " + super.getCommand().getCommandDescriptorBlock().getOperationCode());
		this.writeResponse(Status.GOOD, null);
	}
}
