package org.jscsi.scsi.protocol.inquiry.vpd.deviceidentification;

import java.io.IOException;
import java.nio.ByteBuffer;

public class VendorSpecificIdentifier implements DeviceIdentifier
{
	private byte[] data;

	public VendorSpecificIdentifier(byte[] data)
	{
		this.setData(data);
	}

	public void setData(byte[] data)
	{
		this.data = data;
	}

	public byte[] getData()
	{
		return this.data;
	}

	public byte[] encode() throws IOException
	{
		return this.getData();
	}

	public void decode(byte[] header, ByteBuffer buffer) throws IOException
	{
		buffer.get(this.data);		
	}

	public IdentifierType getType() 
	{
		return IdentifierType.VENDOR_SPECIFIC;
	}
}