package org.jscsi.scsi.protocol.inquiry.vpd.deviceidentification;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class EUI64DeviceIdentifier implements DeviceIdentifier 
{
	// Defined in SPC-3 7.6.3.5.2
	private static final int IEEE_COMPANY_ID_LENGTH = 3;
	private static final int VENDOR_SPECIFIC_EXTENSION_ID_LENGTH = 5;
	
	private byte[] ieeeCompanyID;
	private byte[] vendorSpecificExtensionIdentifier;
	
	public EUI64DeviceIdentifier()
	{
		ieeeCompanyID = new byte[IEEE_COMPANY_ID_LENGTH];
		vendorSpecificExtensionIdentifier = new byte[VENDOR_SPECIFIC_EXTENSION_ID_LENGTH]; 
	}
	
	public EUI64DeviceIdentifier(byte[] ieeeCompanyID, byte[] vendorSpecificExtensionIdentifier)
	{
		this.ieeeCompanyID = ieeeCompanyID;
		this.vendorSpecificExtensionIdentifier = vendorSpecificExtensionIdentifier; 
	}
	
	public void decode(byte[] header, ByteBuffer buffer) throws IOException 
	{
		buffer.get(ieeeCompanyID, 0, IEEE_COMPANY_ID_LENGTH);
		buffer.get(vendorSpecificExtensionIdentifier, IEEE_COMPANY_ID_LENGTH, VENDOR_SPECIFIC_EXTENSION_ID_LENGTH);

	}

	public byte[] encode() throws IOException 
	{
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		baos.write(this.ieeeCompanyID);
		baos.write(this.vendorSpecificExtensionIdentifier);
		return baos.toByteArray();
	}
	
	public IdentifierType getType() 
	{
		return IdentifierType.EUI_64_BASED;
	}

}
