package org.jscsi.scsi.protocol.inquiry.vpd.deviceidentification;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

import org.jscsi.scsi.protocol.cdb.CDB;

public class DeviceIdentifierFactory
{
	private static Map<IdentifierType, Class<? extends DeviceIdentifier>> _identifiers =
		new HashMap<IdentifierType, Class<? extends DeviceIdentifier>>();

	static
	{
		DeviceIdentifierFactory.register(IdentifierType.VENDOR_SPECIFIC, VendorSpecificIdentifier.class);
		DeviceIdentifierFactory.register(IdentifierType.T10_VENDOR_ID_BASED, T10DeviceIdentifier.class);
		DeviceIdentifierFactory.register(IdentifierType.EUI_64_BASED, EUI64DeviceIdentifier.class);
	}

	protected static void register(IdentifierType type, Class<? extends DeviceIdentifier> identifier)
	{
		_identifiers.put(type, identifier);
	}

	@SuppressWarnings("unchecked")
	public static DeviceIdentifier makeDeviceIdentifier(IdentifierType type, ByteBuffer buffer) throws IOException
	{
		if (!_identifiers.containsKey(type))
		{
			throw new IOException(String.format(
					"Unsupported device identifier: %x", type.value()));
		}
		try
		{
			DeviceIdentifier identifier = _identifiers.get(type).newInstance();
			identifier.decode(null, buffer);
			return identifier;
		}
		catch (InstantiationException e)
		{
			throw new IOException("Could not create new cdb parser: " + e.getMessage());
		}
		catch (IllegalAccessException e)
		{
			throw new IOException("Could not create new cdb parser: " + e.getMessage());
		}
	}
	
	public static DeviceIdentifier makeDeviceIdentifier(IdentifierType type, byte[] bytes) throws IOException
	{
		ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
	    buffer.put(bytes);
	    return makeDeviceIdentifier(type, buffer);
	}


}
