/**
 * 
 */
package org.jscsi.scsi.protocol.inquiry.vpd.deviceidentification;

import java.util.HashMap;
import java.util.Map;

public enum CodeSet
   {
	   BINARY_VALUES(0x01),
	   ASCII_PRINTABLE(0x02),
	   UTF8(0x03);
	   
	   private final int value;

	   private static Map<Integer, CodeSet> mapping;
	
	   private CodeSet(final int newValue)
	   {
	      value = newValue;
	      registerMapping(value, this);
	   }
	
	   private static void registerMapping(final Integer key, final CodeSet codeSet)
	   {
	      if (mapping == null)
	      {
	         mapping = new HashMap<Integer, CodeSet>();
	      }
	
	      mapping.put(key, codeSet);
	   }
	
	   public final int value()
	   {
	      return value;
	   }
	
	   public static final CodeSet valueOf(final int value)
	   {
	      return CodeSet.mapping.get(value);
	   }
   }