/**
 * 
 */
package org.jscsi.scsi.protocol.inquiry.vpd.deviceidentification;

import java.util.HashMap;
import java.util.Map;

public enum Association
   {
	   ADDRESSED_LOGICAL_UNIT(0),
	   TARGET_PORT(1),
	   TARGET_DEVICE(2);
	   
	   private final int value;

	   private static Map<Integer, Association> mapping;
	
	   private Association(final int newValue)
	   {
	      value = newValue;
	      registerMapping(value, this);
	   }
	
	   private static void registerMapping(final Integer key, final Association association)
	   {
	      if (mapping == null)
	      {
	         mapping = new HashMap<Integer, Association>();
	      }
	
	      mapping.put(key, association);
	   }
	
	   public final int value()
	   {
	      return value;
	   }
	
	   public static final Association valueOf(final int value)
	   {
	      return Association.mapping.get(value);
	   }
   }