package org.jscsi.scsi.protocol.cdb;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

import org.jscsi.scsi.protocol.util.ByteBufferInputStream;

// Seek10 as defined in SBC-1 6.1.12
public class Seek10 extends AbstractCDB
{
	public static final int OPERATION_CODE = 0x2b;
	private int lba = 0; 
	
	protected Seek10()
	{
		super(OPERATION_CODE);
	}
	
	public int size() 
	{
		return 10;
	}

	public void decode(byte[] header, ByteBuffer buffer) throws IOException
	{
		DataInputStream in = new DataInputStream(new ByteBufferInputStream(buffer));
		int tmp;

		int operationCode = in.readUnsignedByte();
		tmp = in.readUnsignedByte();
		this.lba = in.readInt();
		tmp = in.readByte();
		tmp = in.readByte();
		tmp = in.readByte();
		super.setControl(in.readUnsignedByte());

		if (operationCode != OPERATION_CODE)
		{
			throw new IOException("Invalid operation code: " + Integer.toHexString(operationCode));
		}

	}

	public byte[] encode() throws IOException 
	{
		ByteArrayOutputStream cdb = new ByteArrayOutputStream(this.size());
		DataOutputStream out = new DataOutputStream(cdb);

		try
		{
			//0 Operation code (0x2b)
			out.writeByte(OPERATION_CODE);
			//1 Reserved
			out.writeByte(0);

			//2-5 LBA
			out.writeInt(lba);

			//6-8 Reserved 
			out.writeByte(0);
			out.writeByte(0);
			out.writeByte(0);

			//9 Control
			out.writeByte(super.getControl());

			return cdb.toByteArray();
		}
		catch (IOException e)
		{
			throw new RuntimeException("Unable to encode CDB.");
		}
	}

}
